/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public final class JavaModuleNamingInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaModuleNamingInspection.$$$reportNull$$$0(0);
        }
        return !PsiUtil.isModuleFile((PsiFile)holder.getFile()) ? PsiElementVisitor.EMPTY_VISITOR : new JavaElementVisitor(this){

            public void visitModule(@NotNull PsiJavaModule module) {
                if (module == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitModule(module);
                PsiJavaModuleReferenceElement name = module.getNameIdentifier();
                Ref newName = Ref.create();
                SyntaxTraverser.psiTraverser().children((Object)name).filter(PsiIdentifier.class).forEach(id -> {
                    String text = id.getText();
                    if (!text.isEmpty() && Character.isDigit(text.charAt(text.length() - 1))) {
                        String message = JavaAnalysisBundle.message((String)"inspection.java.module.naming.terminal.digits", (Object[])new Object[]{text});
                        if (newName.isNull()) {
                            newName.set((Object)StringUtil.join((Iterable)SyntaxTraverser.psiTraverser().children((Object)name).filter(PsiIdentifier.class).map(i -> JavaModuleNamingInspection.trimDigits(i.getText())), (String)"."));
                        }
                        holder.registerProblem((PsiElement)id, message, new LocalQuickFix[]{QuickFixFactory.getInstance().createRenameElementFix((PsiNamedElement)module, (String)newName.get())});
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInspection/java19modules/JavaModuleNamingInspection$1", "visitModule"));
            }
        };
    }

    private static String trimDigits(String text) {
        int p;
        for (p = text.length(); p > 0 && Character.isDigit(text.charAt(p - 1)); --p) {
        }
        return text.substring(0, p);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/JavaModuleNamingInspection", "buildVisitor"));
    }
}

