/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.compiler.JavacQuirksInspectionVisitor;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class RedundantTypeArgsInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance(RedundantTypeArgsInspection.class);
    private static final LocalQuickFix ourQuickFixAction = new MyQuickFixAction();
    public static final String SHORT_NAME = "RedundantTypeArguments";

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.verbose.or.redundant.code.constructs", (Object[])new Object[0]);
        if (string == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager inspectionManager, final boolean isOnTheFly) {
        if (place == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(1);
        }
        if (inspectionManager == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(2);
        }
        final ArrayList problems = new ArrayList();
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0) {
                    RedundantTypeArgsInspection.checkCallExpression((PsiJavaCodeReferenceElement)expression.getMethodExpression(), typeArguments, (PsiCallExpression)expression, inspectionManager, problems, isOnTheFly);
                }
            }

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                PsiJavaCodeReferenceElement classReference;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitNewExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0 && (classReference = expression.getClassReference()) != null) {
                    RedundantTypeArgsInspection.checkCallExpression(classReference, typeArguments, (PsiCallExpression)expression, inspectionManager, problems, isOnTheFly);
                }
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitMethodReferenceExpression(expression);
                RedundantTypeArgsInspection.checkMethodReference(expression, inspectionManager, problems, isOnTheFly);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static void checkCallExpression(PsiJavaCodeReferenceElement reference, PsiType[] typeArguments, PsiCallExpression expression, InspectionManager inspectionManager, List<? super ProblemDescriptor> problems, boolean isOnTheFly) {
        PsiExpressionList argumentList = expression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PsiReferenceParameterList typeArgumentList = expression.getTypeArgumentList();
        for (PsiTypeElement typeElement : typeArgumentList.getTypeParameterElements()) {
            if (!typeElement.hasAnnotations()) continue;
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (resolveResult.isValidResult()) {
                PsiTypeParameter[] typeParameters = method.getTypeParameters();
                if (typeParameters.length > 0 && JavacQuirksInspectionVisitor.isSuspicious(expression.getArgumentList().getExpressions(), method)) {
                    return;
                }
                if (typeParameters.length == typeArguments.length && PsiDiamondTypeUtil.areTypeArgumentsRedundant((PsiType[])typeArguments, (PsiExpression)expression, (boolean)false, (PsiMethod)method, (PsiTypeParameter[])typeParameters) || typeParameters.length == 0) {
                    String key = typeParameters.length == 0 ? "inspection.redundant.type.no.generics.problem.descriptor" : "inspection.redundant.type.problem.descriptor";
                    ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)typeArgumentList, JavaAnalysisBundle.message((String)key, (Object[])new Object[0]), ourQuickFixAction, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                    problems.add((ProblemDescriptor)descriptor);
                }
            }
        }
    }

    private static void checkMethodReference(PsiMethodReferenceExpression expression, InspectionManager inspectionManager, List<? super ProblemDescriptor> problems, boolean isOnTheFly) {
        PsiTypeElement qualifierTypeElement = expression.getQualifierType();
        if (qualifierTypeElement != null) {
            PsiType psiType = qualifierTypeElement.getType();
            if (psiType instanceof PsiClassType && !((PsiClassType)psiType).isRaw()) {
                PsiClass aClass = ((PsiClassType)psiType).resolve();
                if (aClass == null) {
                    return;
                }
                JavaResolveResult result = expression.advancedResolve(false);
                PsiElement element = result.getElement();
                if (element instanceof PsiTypeParameterListOwner) {
                    PsiMethod method;
                    PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : null;
                    if (PsiDiamondTypeUtil.areTypeArgumentsRedundant((PsiType[])((PsiClassType)psiType).getParameters(), (PsiExpression)expression, (boolean)false, (PsiMethod)method, (PsiTypeParameter[])aClass.getTypeParameters())) {
                        PsiJavaCodeReferenceElement referenceElement = qualifierTypeElement.getInnermostComponentReferenceElement();
                        LOG.assertTrue(referenceElement != null, (Object)qualifierTypeElement);
                        PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                        LOG.assertTrue(parameterList != null);
                        for (PsiTypeElement typeElement : parameterList.getTypeParameterElements()) {
                            if (!typeElement.hasAnnotations()) continue;
                            return;
                        }
                        ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)parameterList, JavaAnalysisBundle.message((String)"inspection.redundant.type.problem.descriptor", (Object[])new Object[0]), ourQuickFixAction, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                        problems.add((ProblemDescriptor)descriptor);
                    }
                }
            }
        } else {
            PsiType[] typeArguments = expression.getTypeParameters();
            PsiReferenceParameterList parameterList = expression.getParameterList();
            if (typeArguments.length > 0 && parameterList != null) {
                PsiTypeParameter[] typeParameters;
                PsiElement resolve = expression.resolve();
                if (resolve == null) {
                    return;
                }
                PsiTypeParameter[] psiTypeParameterArray = typeParameters = resolve instanceof PsiClass ? PsiTypeParameter.EMPTY_ARRAY : ((PsiMethod)resolve).getTypeParameters();
                if (typeParameters.length == 0 || typeParameters.length == typeArguments.length && PsiDiamondTypeUtil.areTypeArgumentsRedundant((PsiType[])typeArguments, (PsiExpression)expression, (boolean)false, (PsiMethod)((PsiMethod)resolve), (PsiTypeParameter[])typeParameters)) {
                    String key = typeParameters.length == 0 ? "inspection.redundant.type.no.generics.method.reference.problem.descriptor" : "inspection.redundant.type.problem.descriptor";
                    ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)parameterList, JavaAnalysisBundle.message((String)key, (Object[])new Object[0]), (LocalQuickFix)new MyQuickFixAction(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                    problems.add((ProblemDescriptor)descriptor);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class MyQuickFixAction
    extends PsiUpdateModCommandQuickFix {
        private MyQuickFixAction() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.type.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFixAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                MyQuickFixAction.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MyQuickFixAction.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MyQuickFixAction.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiReferenceParameterList)) {
                return;
            }
            PsiReferenceParameterList typeArgumentList = (PsiReferenceParameterList)element;
            try {
                PsiTypeElement qualifierType;
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                PsiMethodReferenceExpression ref = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)typeArgumentList, PsiMethodReferenceExpression.class);
                PsiTypeElement psiTypeElement = qualifierType = ref != null ? ref.getQualifierType() : null;
                if (PsiTreeUtil.isAncestor((PsiElement)qualifierType, (PsiElement)typeArgumentList, (boolean)false)) {
                    PsiClass targetClass = PsiUtil.resolveClassInType((PsiType)qualifierType.getType());
                    if (targetClass != null) {
                        new CommentTracker().replaceAndRestoreComments((PsiElement)qualifierType, (PsiElement)elementFactory.createReferenceExpression(targetClass));
                    }
                } else {
                    PsiMethodCallExpression expr = (PsiMethodCallExpression)elementFactory.createExpressionFromText("foo()", null);
                    new CommentTracker().replaceAndRestoreComments((PsiElement)typeArgumentList, (PsiElement)expr.getTypeArgumentList());
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

