/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructorImpl;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefOverridable;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmMetaLanguage;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;

public final class RefClassImpl
extends RefJavaElementImpl
implements RefClass {
    private static final Set<RefElement> EMPTY_SET = Collections.emptySet();
    private static final Set<RefClass> EMPTY_CLASS_SET = Collections.emptySet();
    private static final int IS_ANONYMOUS_MASK = 65536;
    private static final int IS_INTERFACE_MASK = 131072;
    private static final int IS_UTILITY_MASK = 262144;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_RECORD_MASK = 0x100000;
    private static final int IS_APPLET_MASK = 0x200000;
    private static final int IS_SERVLET_MASK = 0x400000;
    private static final int IS_TESTCASE_MASK = 0x800000;
    private static final int IS_LOCAL_MASK = 0x1000000;
    private static final int IS_ENUM_MASK = 0x2000000;
    private static final int IS_ANNOTATION_MASK = 0x4000000;
    private Object myBases;
    private Set<RefOverridable> myDerivedReferences;
    private RefMethodImpl myDefaultConstructor;
    private Set<RefElement> myInTypeReferences;
    private List<RefJavaElement> myClassExporters;
    private Set<RefClass> myOutTypeReferences;
    private final RefModule myRefModule;

    RefClassImpl(UClass uClass, PsiElement psi, RefManager manager) {
        super((UDeclaration)uClass, psi, manager);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)psi));
    }

    protected synchronized void initialize() {
        WritableRefEntity refParent;
        UClass[] innerClasses;
        this.setDefaultConstructor(null);
        UClass uClass = this.getUastElement();
        LOG.assertTrue(uClass != null);
        UDeclaration parent = UDeclarationKt.getContainingDeclaration((UElement)uClass);
        while (!(parent == null || parent instanceof UMethod || parent instanceof UClass || parent instanceof UField)) {
            parent = UDeclarationKt.getContainingDeclaration((UElement)parent);
        }
        RefManagerImpl manager = this.getRefManager();
        boolean utilityClass = true;
        for (UClass innerClass : innerClasses = uClass.getInnerClasses()) {
            RefElement refInnerClass;
            PsiElement psi = innerClass.getSourcePsi();
            if (psi == null || (refInnerClass = manager.getReference(psi)) == null) continue;
            this.addChild((RefEntity)refInnerClass);
            if (innerClass.isStatic()) continue;
            utilityClass = false;
        }
        WritableRefEntity writableRefEntity = refParent = parent != null ? (WritableRefEntity)manager.getReference(parent.getSourcePsi()) : null;
        if (refParent != null) {
            if (!this.myManager.isDeclarationsFound()) {
                refParent.add((RefEntity)this);
            } else {
                this.setOwner(refParent);
            }
        } else {
            PsiFile containingFile = this.getContainingFile();
            if (this.isSyntheticJSP()) {
                PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)this.getPsiElement());
                UField[] refFile = (UField[])manager.getReference((PsiElement)psiFile);
                LOG.assertTrue(refFile != null);
                refFile.add((RefEntity)this);
            } else if (RefClassImpl.isKindOfJvmLanguage(containingFile.getLanguage())) {
                String packageName = ((UFile)UastContextKt.toUElement((PsiElement)containingFile, UFile.class)).getPackageName();
                if (!packageName.isEmpty()) {
                    ((RefPackageImpl)this.getRefJavaManager().getPackage(packageName)).add((RefEntity)this);
                } else {
                    ((RefPackageImpl)this.getRefJavaManager().getDefaultPackage()).add((RefEntity)this);
                }
            } else {
                ((WritableRefEntity)this.myRefModule).add((RefEntity)this);
            }
        }
        if (!this.myManager.isDeclarationsFound()) {
            return;
        }
        this.setInterface(uClass.isInterface());
        this.setAnnotationType(uClass.isAnnotationType());
        this.setAnonymous(uClass instanceof UAnonymousClass);
        PsiClass psiClass = uClass.getJavaPsi();
        if (!this.isAnonymous()) {
            this.setRecord(psiClass.isRecord());
            this.setEnum(psiClass.isEnum());
            this.setAbstract(psiClass.hasModifier(JvmModifier.ABSTRACT));
            this.setLocal(parent != null && !(parent instanceof UClass));
        }
        this.initializeSuperReferences(uClass);
        boolean memberSeen = false;
        for (UField uField : uClass.getFields()) {
            RefElement refElement = manager.getReference(uField.getSourcePsi());
            if (!(refElement instanceof RefField)) continue;
            RefField field = (RefField)refElement;
            memberSeen = true;
            this.addChild((RefEntity)field);
            if (uField.isStatic() && !(uField instanceof UEnumConstant)) continue;
            utilityClass = false;
        }
        RefMethodImpl varargConstructor = null;
        boolean constructorSeen = false;
        for (UMethod uMethod : uClass.getMethods()) {
            RefElement refElement = manager.getReference(uMethod.getSourcePsi());
            if (!(refElement instanceof RefMethodImpl)) continue;
            RefMethodImpl refMethod = (RefMethodImpl)refElement;
            this.addChild((RefEntity)refMethod);
            if (uMethod.isConstructor()) {
                PsiElement parameterPsi;
                constructorSeen = true;
                List parameters = uMethod.getUastParameters();
                if (!parameters.isEmpty() || uMethod.getVisibility() != UastVisibility.PRIVATE) {
                    utilityClass = false;
                }
                if (parameters.isEmpty()) {
                    this.setDefaultConstructor(refMethod);
                    continue;
                }
                if (parameters.size() != 1 || !((parameterPsi = ((UParameter)parameters.get(0)).getJavaPsi()) instanceof PsiParameter) || !((PsiParameter)parameterPsi).isVarArgs()) continue;
                varargConstructor = refMethod;
                continue;
            }
            memberSeen = true;
            if (uMethod.isStatic()) continue;
            utilityClass = false;
        }
        if (!memberSeen || this.isInterface() || this.isRecord() || this.isAnonymous()) {
            utilityClass = false;
        }
        if (!utilityClass && psiClass.getLanguage().isKindOf("kotlin")) {
            utilityClass = ClassUtils.isSingleton(psiClass);
        }
        if (this.myDefaultConstructor == null && varargConstructor != null) {
            this.setDefaultConstructor(varargConstructor);
        }
        if (!(constructorSeen || this.isInterface() || this.isAnonymous())) {
            this.setDefaultConstructor(new RefImplicitConstructorImpl(this));
        }
        this.setUtilityClass(utilityClass);
        if (!utilityClass) {
            PsiElement psi;
            this.setApplet(this.getRefJavaManager().getApplet() != null && JvmInheritanceUtil.isInheritor((JvmClass)uClass, (String)this.getRefJavaManager().getAppletQName()));
            if (!this.isApplet()) {
                this.setServlet(JvmInheritanceUtil.isInheritor((JvmClass)psiClass, (String)this.getRefJavaManager().getServletQName()));
            }
            if (!this.isApplet() && !this.isServlet() && (psi = uClass.getSourcePsi()) instanceof PsiClass) {
                boolean isTestClass = TestFrameworks.getInstance().isTestClass((PsiClass)psi);
                this.setTestCase(isTestClass);
                if (isTestClass) {
                    for (RefClass refBase : this.getBaseClasses()) {
                        ((RefClassImpl)refBase).setTestCase(true);
                    }
                }
            }
        }
    }

    private void initializeSuperReferences(UClass uClass) {
        uClass.getUastSuperTypes().stream().map(t -> PsiUtil.resolveClassInClassTypeOnly((PsiType)t.getType())).filter(Objects::nonNull).filter(c -> this.getRefJavaManager().belongsToScope((PsiElement)c)).forEach(c -> {
            RefClassImpl refClass = (RefClassImpl)this.getRefManager().getReference((PsiElement)c);
            if (refClass != null) {
                this.addBaseClass(refClass);
                this.getRefManager().executeTask(() -> refClass.addDerivedReference((RefOverridable)this));
            }
        });
    }

    public boolean isSelfInheritor(@NotNull UClass uClass) {
        if (uClass == null) {
            RefClassImpl.$$$reportNull$$$0(0);
        }
        return RefClassImpl.isSelfInheritor(uClass, new ArrayList());
    }

    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    private static boolean isSelfInheritor(UClass uClass, List<? super UClass> visited) {
        if (visited.contains(uClass)) {
            return true;
        }
        visited.add((UClass)uClass);
        if (uClass.getUastSuperTypes().stream().map(t -> PsiUtil.resolveClassInClassTypeOnly((PsiType)t.getType())).map(c -> (UClass)UastContextKt.toUElement((PsiElement)c, UClass.class)).filter(Objects::nonNull).anyMatch(c -> RefClassImpl.isSelfInheritor(c, visited))) {
            return true;
        }
        visited.remove(uClass);
        return false;
    }

    private synchronized void setDefaultConstructor(RefMethodImpl defaultConstructor) {
        this.myDefaultConstructor = defaultConstructor;
    }

    public UClass getUastElement() {
        return (UClass)UastContextKt.toUElement((PsiElement)this.getPsiElement(), UClass.class);
    }

    @NotNull
    public String getQualifiedName() {
        UClass uClass = this.getUastElement();
        if (uClass == null) {
            String string = super.getQualifiedName();
            if (string == null) {
                RefClassImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        String qName = uClass.getQualifiedName();
        if (qName == null) {
            String string = super.getQualifiedName();
            if (string == null) {
                RefClassImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = qName;
        if (string == null) {
            RefClassImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void buildReferences() {
        UClass uClass = this.getUastElement();
        if (uClass != null) {
            UMethod[] uMethods;
            PsiTypeParameter[] objectAccess;
            PsiElement classSourcePsi = uClass.getSourcePsi();
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            if (uClass instanceof UAnonymousClass && (objectAccess = (PsiTypeParameter[])UastUtils.getParentOfType((UElement)uClass, UObjectLiteralExpression.class)) != null && objectAccess.getDeclaration().getSourcePsi() == classSourcePsi) {
                refUtil.addReferencesTo((UElement)uClass, (RefJavaElement)this, objectAccess.getValueArguments().toArray(UElementKt.EMPTY_ARRAY));
            }
            for (UObjectLiteralExpression uObjectLiteralExpression : uClass.getInitializers()) {
                refUtil.addReferencesTo((UElement)uClass, (RefJavaElement)this, new UElement[]{uObjectLiteralExpression.getUastBody()});
            }
            refUtil.addReferencesTo((UElement)uClass, (RefJavaElement)this, uClass.getUAnnotations().toArray(UElementKt.EMPTY_ARRAY));
            for (PsiTypeParameter psiTypeParameter : uClass.getJavaPsi().getTypeParameters()) {
                UElement uTypeParameter = UastContextKt.toUElement((PsiElement)psiTypeParameter);
                if (uTypeParameter == null) continue;
                refUtil.addReferencesTo((UElement)uClass, (RefJavaElement)this, new UElement[]{uTypeParameter});
            }
            RefMethodImpl defaultConstructor = (RefMethodImpl)this.getDefaultConstructor();
            if (defaultConstructor != null) {
                for (RefClass superClass : this.getBaseClasses()) {
                    superClass.initializeIfNeeded();
                    WritableRefElement writableRefElement = (WritableRefElement)superClass.getDefaultConstructor();
                    if (writableRefElement == null) continue;
                    writableRefElement.addInReference((RefElement)defaultConstructor);
                    defaultConstructor.addOutReference((RefElement)writableRefElement);
                }
            }
            for (UMethod uMethod : uMethods = uClass.getMethods()) {
                if (uMethod.getSourcePsi() != classSourcePsi) continue;
                refUtil.addReferencesTo((UElement)uClass, (RefJavaElement)this, new UElement[]{uMethod.getUastBody()});
            }
            refUtil.addReferencesTo((UElement)uClass, (RefJavaElement)this, uClass.getUastSuperTypes().toArray(UElementKt.EMPTY_ARRAY));
        }
    }

    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 == null) {
            RefClassImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 instanceof RefJavaVisitor) {
            RefJavaVisitor javaVisitor = (RefJavaVisitor)visitor2;
            ReadAction.run(() -> javaVisitor.visitClass((RefClass)this));
        } else {
            super.accept(visitor2);
        }
    }

    @NotNull
    public synchronized Set<RefClass> getBaseClasses() {
        if (this.myBases == null) {
            Set<RefClass> set = EMPTY_CLASS_SET;
            if (set == null) {
                RefClassImpl.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<RefClass> set = this.myBases instanceof Set ? (Set<RefClass>)this.myBases : Collections.singleton((RefClass)this.myBases);
        if (set == null) {
            RefClassImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    private synchronized void addBaseClass(RefClass refClass) {
        if (this.myBases == null) {
            this.myBases = refClass;
        } else if (this.myBases instanceof RefClass) {
            HashSet<RefClass> set = new HashSet<RefClass>();
            set.add((RefClass)this.myBases);
            set.add(refClass);
            this.myBases = set;
        } else {
            ((Set)this.myBases).add(refClass);
        }
    }

    @NotNull
    public synchronized Set<RefClass> getSubClasses() {
        LOG.assertTrue(this.isInitialized());
        if (this.myDerivedReferences == null) {
            Set<RefClass> set = EMPTY_CLASS_SET;
            if (set == null) {
                RefClassImpl.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set set = StreamEx.of(this.myDerivedReferences).select(RefClass.class).toSet();
        if (set == null) {
            RefClassImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public synchronized Collection<? extends RefOverridable> getDerivedReferences() {
        Set<Object> set = this.myDerivedReferences == null ? EMPTY_CLASS_SET : this.myDerivedReferences;
        if (set == null) {
            RefClassImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    public synchronized void addDerivedReference(@NotNull RefOverridable reference) {
        if (reference == null) {
            RefClassImpl.$$$reportNull$$$0(10);
        }
        if (this.myDerivedReferences == null) {
            this.myDerivedReferences = Collections.singleton(reference);
            return;
        }
        if (this.myDerivedReferences.size() == 1) {
            this.myDerivedReferences = new HashSet<RefOverridable>(this.myDerivedReferences);
        }
        this.myDerivedReferences.add(reference);
    }

    private synchronized void removeSubClass(RefClass refClass) {
        if (this.myDerivedReferences == null) {
            return;
        }
        if (this.myDerivedReferences.size() == 1) {
            this.myDerivedReferences = null;
        } else {
            this.myDerivedReferences.remove(refClass);
        }
    }

    @NotNull
    public synchronized List<RefMethod> getConstructors() {
        LOG.assertTrue(this.isInitialized());
        List list = ((StreamEx)StreamEx.of((Collection)this.getChildren()).select(RefMethod.class).filter(RefMethod::isConstructor)).toList();
        if (list == null) {
            RefClassImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    public @Unmodifiable List<RefField> getFields() {
        LOG.assertTrue(this.isInitialized());
        return ContainerUtil.filterIsInstance((Collection)this.getChildren(), RefField.class);
    }

    @NotNull
    public synchronized Set<RefElement> getInTypeReferences() {
        if (this.myInTypeReferences == null) {
            Set<RefElement> set = EMPTY_SET;
            if (set == null) {
                RefClassImpl.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set<RefElement> set = this.myInTypeReferences;
        if (set == null) {
            RefClassImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTypeReference(RefJavaElement from) {
        if (from != null) {
            RefClassImpl refClassImpl = this;
            synchronized (refClassImpl) {
                if (this.myInTypeReferences == null) {
                    this.myInTypeReferences = new HashSet<RefElement>(1);
                }
                this.myInTypeReferences.add((RefElement)from);
            }
            ((RefJavaElementImpl)from).addOutTypeReference(this);
            this.getRefManager().fireNodeMarkedReferenced((RefElement)this, (RefElement)from, false, false, false);
        }
    }

    public synchronized RefMethod getDefaultConstructor() {
        return this.myDefaultConstructor;
    }

    @NotNull
    public synchronized List<RefMethod> getLibraryMethods() {
        List list = ((StreamEx)StreamEx.of((Collection)this.getChildren()).select(RefMethod.class).filter(RefMethod::isExternalOverride)).toList();
        if (list == null) {
            RefClassImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    public boolean isAnonymous() {
        return this.checkFlag(65536L);
    }

    public boolean isInterface() {
        return this.checkFlag(131072L);
    }

    public boolean isRecord() {
        return this.checkFlag(0x100000L);
    }

    public boolean isAnnotationType() {
        return this.checkFlag(0x4000000L);
    }

    public boolean isUtilityClass() {
        return this.checkFlag(262144L);
    }

    public String getExternalName() {
        return (String)ReadAction.compute(() -> {
            UClass psiClass = this.getUastElement();
            LOG.assertTrue(psiClass != null, (Object)("No uast class found for psi: " + String.valueOf(this.getPsiElement())));
            return PsiFormatUtil.getExternalName((PsiModifierListOwner)psiClass.getJavaPsi());
        });
    }

    @Nullable
    static RefClass classFromExternalName(RefManager manager, String externalName) {
        return (RefClass)manager.getReference((PsiElement)ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)manager.getProject()), (String)externalName));
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        for (RefClass subClass : this.getSubClasses()) {
            ((RefClassImpl)subClass).removeBaseClass(this);
        }
        for (RefClass superClass : this.getBaseClasses()) {
            ((RefClassImpl)superClass).removeSubClass(this);
        }
    }

    private synchronized void removeBaseClass(RefClass superClass) {
        if (this.myBases instanceof RefClass) {
            if (this.myBases == superClass) {
                this.myBases = null;
            }
        } else if (this.myBases != null) {
            ((Set)this.myBases).remove(superClass);
        }
    }

    void methodRemoved(RefMethod method) {
        if (this.getDefaultConstructor() == method) {
            this.setDefaultConstructor(null);
        }
    }

    public boolean isAbstract() {
        return this.checkFlag(524288L);
    }

    public boolean isApplet() {
        return this.checkFlag(0x200000L);
    }

    public boolean isServlet() {
        return this.checkFlag(0x400000L);
    }

    public boolean isTestCase() {
        return this.checkFlag(0x800000L);
    }

    public boolean isLocalClass() {
        return this.checkFlag(0x1000000L);
    }

    public boolean isEnum() {
        return this.checkFlag(0x2000000L);
    }

    public synchronized boolean isReferenced() {
        if (super.isReferenced()) {
            return true;
        }
        if (this.isInterface()) {
            return !this.getDerivedReferences().isEmpty();
        }
        if (this.isAbstract()) {
            return !this.getSubClasses().isEmpty();
        }
        return false;
    }

    public boolean hasSuspiciousCallers() {
        if (super.hasSuspiciousCallers()) {
            return true;
        }
        if (this.isInterface()) {
            return !this.getDerivedReferences().isEmpty();
        }
        if (this.isAbstract()) {
            return !this.getSubClasses().isEmpty();
        }
        return false;
    }

    synchronized void addClassExporter(RefJavaElement exporter) {
        if (this.myClassExporters == null) {
            this.myClassExporters = new ArrayList<RefJavaElement>(1);
        }
        if (this.myClassExporters.contains(exporter)) {
            return;
        }
        this.myClassExporters.add(exporter);
    }

    @Override
    synchronized void addOutTypeReference(RefClass refClass) {
        if (this.myOutTypeReferences == null) {
            this.myOutTypeReferences = new HashSet<RefClass>();
        }
        this.myOutTypeReferences.add(refClass);
    }

    public synchronized List<RefJavaElement> getClassExporters() {
        return this.myClassExporters;
    }

    @Override
    @NotNull
    public synchronized Collection<RefClass> getOutTypeReferences() {
        Set<Object> set = this.myOutTypeReferences == null ? Collections.emptySet() : this.myOutTypeReferences;
        if (set == null) {
            RefClassImpl.$$$reportNull$$$0(15);
        }
        return set;
    }

    private void setAnonymous(boolean anonymous) {
        this.setFlag(anonymous, 65536L);
    }

    private void setInterface(boolean isInterface) {
        this.setFlag(isInterface, 131072L);
    }

    private void setRecord(boolean record) {
        this.setFlag(record, 0x100000L);
    }

    private void setAnnotationType(boolean annotationType) {
        this.setFlag(annotationType, 0x4000000L);
    }

    private void setUtilityClass(boolean utilityClass) {
        this.setFlag(utilityClass, 262144L);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288L);
    }

    private void setApplet(boolean applet) {
        this.setFlag(applet, 0x200000L);
    }

    private void setServlet(boolean servlet) {
        this.setFlag(servlet, 0x400000L);
    }

    private void setTestCase(boolean testCase) {
        this.setFlag(testCase, 0x800000L);
    }

    private void setLocal(boolean isLocal) {
        this.setFlag(isLocal, 0x1000000L);
    }

    private void setEnum(boolean isEnum) {
        this.setFlag(isEnum, 0x2000000L);
    }

    @NotNull
    public RefElement getContainingEntry() {
        RefMethod defaultConstructor = this.getDefaultConstructor();
        Object object = defaultConstructor == null ? super.getContainingEntry() : defaultConstructor;
        if (object == null) {
            RefClassImpl.$$$reportNull$$$0(16);
        }
        return object;
    }

    private static boolean isKindOfJvmLanguage(@NotNull Language language) {
        if (language == null) {
            RefClassImpl.$$$reportNull$$$0(17);
        }
        for (Language t : ((JvmMetaLanguage)Language.findInstance(JvmMetaLanguage.class)).getMatchingLanguages()) {
            if (!language.is(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isSuppressed(String ... toolIds) {
        RefJavaFileImpl file;
        if (toolIds == null) {
            RefClassImpl.$$$reportNull$$$0(18);
        }
        if (super.isSuppressed(toolIds)) {
            return true;
        }
        RefElement fileRef = this.getRefManager().getReference((PsiElement)this.getContainingFile());
        return fileRef instanceof RefJavaFileImpl && (file = (RefJavaFileImpl)fileRef).isSuppressed(toolIds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefClassImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefClassImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClasses";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubClasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedReferences";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInTypeReferences";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMethods";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutTypeReferences";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelfInheritor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isKindOfJvmLanguage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

