/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefFunctionalExpression;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.java.codeserver.core.JavaPsiMethodUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.VisibilityUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastOperator;
import org.jetbrains.uast.UastPostfixOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public final class RefJavaUtilImpl
extends RefJavaUtil {
    private static final Logger LOG = Logger.getInstance(RefJavaUtilImpl.class);

    public void addReferences(@NotNull PsiModifierListOwner psiFrom, @NotNull RefJavaElement ref, @Nullable PsiElement findIn) {
        if (psiFrom == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(0);
        }
        if (ref == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(1);
        }
        UDeclaration decl = (UDeclaration)UastContextKt.toUElement((PsiElement)psiFrom, UDeclaration.class);
        UElement uFindIn = UastContextKt.toUElement((PsiElement)findIn);
        if (decl != null && findIn != null) {
            this.addReferencesTo((UElement)decl, ref, uFindIn);
        }
    }

    public void addReferencesTo(final @NotNull UElement decl, @NotNull RefJavaElement ref, UElement ... findIn) {
        if (decl == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(2);
        }
        if (ref == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(3);
        }
        final RefJavaElementImpl refFrom = (RefJavaElementImpl)ref;
        final RefManagerImpl refManager = refFrom.getRefManager();
        if (findIn == null) {
            return;
        }
        for (UElement element : findIn) {
            if (element == null) continue;
            element.accept((UastVisitor)new AbstractUastVisitor(){

                public boolean visitEnumConstant(@NotNull UEnumConstant node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.processNewLikeConstruct((PsiElement)node.resolve(), (UCallExpression)node);
                    return false;
                }

                public boolean visitNamedExpression(@NotNull UNamedExpression node) {
                    PsiElement target;
                    RefElement refElement;
                    PsiNameValuePair pair;
                    PsiReference reference;
                    PsiElement source;
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((source = node.getSourcePsi()) instanceof PsiNameValuePair && (reference = (pair = (PsiNameValuePair)source).getReference()) != null && (refElement = refManager.getReference(target = reference.resolve())) != null) {
                        refElement.initializeIfNeeded();
                        refFrom.addReference(refElement, target, decl, false, true, (UExpression)node);
                    }
                    return false;
                }

                public boolean visitAnnotation(@NotNull UAnnotation node) {
                    PsiClass javaClass;
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ((javaClass = node.resolve()) != null) {
                        RefElement refClass = refManager.getReference(javaClass.getOriginalElement());
                        if (refClass != null) {
                            refClass.initializeIfNeeded();
                        }
                        refFrom.addReference(refClass, javaClass.getOriginalElement(), decl, false, true, null);
                        this.checkRepeatableAnnotation(javaClass, node);
                    }
                    return false;
                }

                private void checkRepeatableAnnotation(PsiClass annotationClass, UAnnotation annotation) {
                    if (!"java.lang.annotation.Repeatable".equals(annotationClass.getQualifiedName())) {
                        return;
                    }
                    UExpression value = annotation.findAttributeValue("value");
                    while (value instanceof UParenthesizedExpression) {
                        UParenthesizedExpression parenth = (UParenthesizedExpression)value;
                        value = parenth.getExpression();
                    }
                    if (!(value instanceof UClassLiteralExpression)) {
                        return;
                    }
                    UClassLiteralExpression classLiteralExpression = (UClassLiteralExpression)value;
                    PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)classLiteralExpression.getType());
                    if (aClass == null) {
                        return;
                    }
                    RefElement refElement = refManager.getReference(aClass.getOriginalElement());
                    if (!(refElement instanceof RefClassImpl)) {
                        return;
                    }
                    RefClassImpl refClass = (RefClassImpl)refElement;
                    refClass.initializeIfNeeded();
                    for (RefEntity child : refClass.getChildren()) {
                        RefMethod method;
                        if (!(child instanceof RefMethod) || !"value()".equals((method = (RefMethod)child).getName())) continue;
                        refFrom.addReference((RefElement)method, null, decl, false, true, null);
                        break;
                    }
                }

                public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    PsiType type = node.getType();
                    this.visitTypeRefs(type);
                    return false;
                }

                private void visitTypeRefs(PsiType type) {
                    if ((type = type.getDeepComponentType()) instanceof PsiClassType) {
                        type.accept((PsiTypeVisitor)new PsiTypeVisitor<Void>(){

                            public Void visitClassType(@NotNull PsiClassType classType) {
                                if (classType == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                for (PsiType parameter : classType.getParameters()) {
                                    parameter.accept((PsiTypeVisitor)this);
                                }
                                PsiClass aClass = classType.resolve();
                                UClass target = (UClass)UastContextKt.toUElement((PsiElement)aClass, UClass.class);
                                if (target != null) {
                                    RefElement refElement = refManager.getReference(target.getSourcePsi());
                                    if (refElement != null) {
                                        refElement.initializeIfNeeded();
                                    }
                                    refFrom.addReference(refElement, (PsiElement)aClass, decl, false, true, null);
                                }
                                return null;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/codeInspection/reference/RefJavaUtilImpl$1$1", "visitClassType"));
                            }
                        });
                    }
                }

                public boolean visitVariable(@NotNull UVariable node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    this.visitTypeRefs(node.getType());
                    return false;
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitLiteralExpression(@NotNull ULiteralExpression node) {
                    PsiElement sourcePsi;
                    if (node == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    if ((sourcePsi = node.getSourcePsi()) != null) {
                        for (PsiReference reference : sourcePsi.getReferences()) {
                            PsiElement resolve = reference.resolve();
                            if (!(resolve instanceof PsiMember)) continue;
                            RefElement refResolved = refManager.getReference(resolve);
                            if (refResolved != null) {
                                refResolved.initializeIfNeeded();
                            }
                            refFrom.addReference(refResolved, resolve, decl, false, true, null);
                            if (!(refResolved instanceof RefMethodImpl)) continue;
                            RefMethodImpl refMethod = (RefMethodImpl)refResolved;
                            RefJavaUtilImpl.this.updateRefMethod(resolve, refMethod, (UExpression)node, decl);
                        }
                    }
                    return false;
                }

                public boolean visitPrefixExpression(@NotNull UPrefixExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitPostfixExpression(@NotNull UPostfixExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitUnaryExpression(@NotNull UUnaryExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(10);
                    }
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(11);
                    }
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(12);
                    }
                    this.visitReferenceExpression((UExpression)node);
                    this.visitClass(node.getDeclaration());
                    return false;
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(13);
                    }
                    this.visitReferenceExpression((UExpression)node);
                    if (node instanceof UObjectLiteralExpression) {
                        UObjectLiteralExpression objectLiteralExpression = (UObjectLiteralExpression)node;
                        this.visitClass(objectLiteralExpression.getDeclaration());
                    }
                    if (node.getKind() == UastCallKind.CONSTRUCTOR_CALL) {
                        PsiElement resolvedMethod = RefJavaUtilImpl.returnToPhysical((PsiElement)node.resolve());
                        this.processNewLikeConstruct(resolvedMethod, node);
                    }
                    try {
                        node.getTypeArguments().forEach(this::visitTypeRefs);
                    }
                    catch (UnsupportedOperationException e) {
                        LOG.error((Throwable)e);
                    }
                    return false;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                private void visitReferenceExpression(@NotNull UExpression node) {
                    UExpression uExpression;
                    UCallExpression callExpression;
                    UQualifiedReferenceExpression qualifiedReference;
                    UElement uastParent;
                    if (node == null) {
                        1.$$$reportNull$$$0(14);
                    }
                    if ((uastParent = node.getUastParent()) instanceof UQualifiedReferenceExpression && (qualifiedReference = (UQualifiedReferenceExpression)uastParent).getSelector() == node) {
                        return;
                    }
                    PsiElement psiResolved = null;
                    if (node instanceof UCallExpression && "invoke".equals((callExpression = (UCallExpression)node).getMethodName()) && (uExpression = callExpression.getReceiver()) instanceof UResolvable) {
                        UResolvable resolvable = (UResolvable)uExpression;
                        psiResolved = resolvable.resolve();
                    } else if (node instanceof UResolvable) {
                        UResolvable resolvable = (UResolvable)node;
                        psiResolved = resolvable.resolve();
                    } else if (node instanceof UBinaryExpression) {
                        UBinaryExpression binaryExpression = (UBinaryExpression)node;
                        psiResolved = binaryExpression.resolveOperator();
                    } else if (node instanceof UUnaryExpression) {
                        UUnaryExpression unaryExpression = (UUnaryExpression)node;
                        psiResolved = unaryExpression.resolveOperator();
                    }
                    psiResolved = RefJavaUtilImpl.returnToPhysical(psiResolved);
                    RefElement refResolved = refManager.getReference(psiResolved);
                    boolean writing = RefJavaUtilImpl.isAccessedForWriting((UElement)node);
                    boolean reading = RefJavaUtilImpl.isAccessedForReading((UElement)node);
                    if (refResolved != null) {
                        refResolved.initializeIfNeeded();
                    }
                    refFrom.addReference(refResolved, psiResolved, decl, writing, reading, node);
                    if (refResolved instanceof RefMethodImpl) {
                        RefMethodImpl refMethod = (RefMethodImpl)refResolved;
                        RefJavaUtilImpl.this.updateRefMethod(psiResolved, refMethod, node, decl);
                    } else if (refResolved instanceof RefField) {
                        UResolvable resolvable;
                        UMethod uProperty;
                        if (node instanceof UResolvable && (uProperty = (UMethod)UastContextKt.toUElement((PsiElement)(resolvable = (UResolvable)node).resolve(), UMethod.class)) == null) {
                            // empty if block
                        }
                    } else if (refResolved == null && psiResolved instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)psiResolved;
                        this.markEnumUsedIfValuesMethod(method, node);
                    }
                    if (psiResolved instanceof PsiMember) {
                        PsiMember psiMember = (PsiMember)psiResolved;
                        RefJavaUtilImpl.addClassReferenceForStaticImport(node, psiMember, refFrom, decl);
                    }
                }

                public boolean visitLambdaExpression(@NotNull ULambdaExpression lambda) {
                    if (lambda == null) {
                        1.$$$reportNull$$$0(15);
                    }
                    this.processFunctionalExpression((UExpression)lambda, lambda.getFunctionalInterfaceType());
                    return true;
                }

                private void markEnumUsedIfValuesMethod(PsiMethod psiWhat, UExpression expression) {
                    PsiClass containingClass = psiWhat.getContainingClass();
                    if (containingClass == null || !containingClass.isEnum()) {
                        return;
                    }
                    String methodName = psiWhat.getName();
                    if (!"values".equals(methodName) && !"valueOf".equals(methodName)) {
                        return;
                    }
                    for (PsiField enumConstant : containingClass.getFields()) {
                        RefJavaElementImpl enumConstantReference;
                        if (!(enumConstant instanceof PsiEnumConstant) || (enumConstantReference = (RefJavaElementImpl)refFrom.getRefManager().getReference((PsiElement)enumConstant)) == null) continue;
                        refFrom.addOutReference((RefElement)enumConstantReference);
                        enumConstantReference.markReferenced(refFrom, false, true, expression);
                    }
                }

                public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression methodRef) {
                    RefElement refMethod;
                    UExpression qualifierExpression;
                    if (methodRef == null) {
                        1.$$$reportNull$$$0(16);
                    }
                    if ((qualifierExpression = methodRef.getQualifierExpression()) != null) {
                        qualifierExpression.accept((UastVisitor)this);
                    }
                    if (refFrom == (refMethod = refManager.getReference(methodRef.getSourcePsi()))) {
                        this.visitReferenceExpression((UExpression)methodRef);
                        return false;
                    }
                    this.processFunctionalExpression((UExpression)methodRef, RefJavaUtilImpl.getFunctionalInterfaceType(methodRef));
                    return true;
                }

                private void processFunctionalExpression(@NotNull UExpression expression, @Nullable PsiType type) {
                    PsiElement functionalExpr;
                    RefElement refFunctionalExpr;
                    PsiClass aClass;
                    if (expression == null) {
                        1.$$$reportNull$$$0(17);
                    }
                    if ((aClass = PsiUtil.resolveClassInType((PsiType)type)) != null) {
                        aClass = aClass.getSourceElement();
                    }
                    if (aClass != null) {
                        RefElement refWhat = refManager.getReference((PsiElement)aClass);
                        if (refWhat != null) {
                            refWhat.initializeIfNeeded();
                        }
                        refFrom.addReference(refWhat, (PsiElement)aClass, decl, false, true, null);
                    }
                    if ((refFunctionalExpr = refManager.getReference(functionalExpr = expression.getSourcePsi())) != null) {
                        refFunctionalExpr.initializeIfNeeded();
                    }
                    refFrom.addReference(refFunctionalExpr, functionalExpr, decl, false, true, expression);
                }

                private void processNewLikeConstruct(PsiElement javaConstructor, UCallExpression call) {
                    RefElement refElement;
                    if (javaConstructor != null && (refElement = refManager.getReference(javaConstructor.getOriginalElement())) instanceof RefMethodImpl) {
                        RefMethodImpl refConstructor = (RefMethodImpl)refElement;
                        refConstructor.initializeIfNeeded();
                        refFrom.addReference((RefElement)refConstructor, javaConstructor, decl, false, true, (UExpression)call);
                        refConstructor.updateParameterValues(call, javaConstructor);
                    } else {
                        PsiElement constructorClass;
                        UReferenceExpression reference = call.getClassReference();
                        if (reference != null && (constructorClass = reference.resolve()) instanceof PsiClass) {
                            PsiClass psiClass = (PsiClass)constructorClass;
                            this.processClassReference(psiClass, true, (UExpression)call);
                        }
                    }
                    for (UExpression arg : call.getValueArguments()) {
                        arg.accept((UastVisitor)this);
                    }
                }

                public boolean visitClass(@NotNull UClass uClass) {
                    if (uClass == null) {
                        1.$$$reportNull$$$0(18);
                    }
                    for (UTypeReferenceExpression type : uClass.getUastSuperTypes()) {
                        type.accept((UastVisitor)this);
                    }
                    PsiElement sourcePsi = uClass.getSourcePsi();
                    RefElement refWhat = refManager.getReference(sourcePsi);
                    if (refWhat != null) {
                        refWhat.initializeIfNeeded();
                    }
                    refFrom.addReference(refWhat, sourcePsi, decl, false, true, null);
                    return true;
                }

                public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(19);
                    }
                    RefMethodImpl refMethod = null;
                    if (refFrom instanceof RefMethodImpl && UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)false, (Class[])new Class[]{UClass.class, ULambdaExpression.class}) == decl) {
                        refMethod = (RefMethodImpl)refFrom;
                    } else if (refFrom instanceof RefFunctionalExpression) {
                        UElement target = node.getJumpTarget();
                        if (target instanceof UMethod) {
                            RefMethodImpl m;
                            RefElement refElement = refManager.getReference(target.getSourcePsi());
                            refMethod = refElement instanceof RefMethodImpl ? (m = (RefMethodImpl)refElement) : null;
                        } else if (decl instanceof ULambdaExpression) {
                            RefMethodImpl m;
                            ULambdaExpression lambdaExpression = (ULambdaExpression)decl;
                            PsiMethod lambdaMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)lambdaExpression.getFunctionalInterfaceType());
                            RefElement refElement = refManager.getReference((PsiElement)lambdaMethod);
                            RefMethodImpl refMethodImpl = refMethod = refElement instanceof RefMethodImpl ? (m = (RefMethodImpl)refElement) : null;
                        }
                    }
                    if (refMethod != null) {
                        refMethod.initializeIfNeeded();
                        refMethod.updateReturnValueTemplate(node.getReturnExpression());
                    }
                    return false;
                }

                public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(20);
                    }
                    this.processClassReference(PsiUtil.resolveClassInClassTypeOnly((PsiType)node.getType()), false, (UExpression)node);
                    return false;
                }

                private void processClassReference(PsiClass psiClass, boolean defaultConstructorOnly, UExpression node) {
                    RefElement refElement;
                    if (psiClass != null && (refElement = refManager.getReference(psiClass.getNavigationElement())) instanceof RefClassImpl) {
                        RefClassImpl refClass = (RefClassImpl)refElement;
                        boolean hasConstructorsMarked = false;
                        refClass.initializeIfNeeded();
                        if (defaultConstructorOnly) {
                            WritableRefElement refDefaultConstructor = (WritableRefElement)refClass.getDefaultConstructor();
                            if (refDefaultConstructor != null) {
                                refDefaultConstructor.addInReference((RefElement)refFrom);
                                refFrom.addOutReference((RefElement)refDefaultConstructor);
                                hasConstructorsMarked = true;
                            }
                        } else {
                            for (RefMethod cons : refClass.getConstructors()) {
                                if (cons instanceof RefImplicitConstructor) continue;
                                ((WritableRefElement)cons).addInReference((RefElement)refFrom);
                                refFrom.addOutReference((RefElement)cons);
                                hasConstructorsMarked = true;
                            }
                            if (refClass.isEnum()) {
                                for (RefField field : refClass.getFields()) {
                                    if (!field.isEnumConstant()) continue;
                                    ((RefFieldImpl)field).markReferenced(refFrom, false, true, node);
                                    refFrom.addOutReference((RefElement)field);
                                }
                            }
                        }
                        if (!hasConstructorsMarked) {
                            refFrom.addReference((RefElement)refClass, (PsiElement)psiClass, decl, false, true, node);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 15: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "lambda";
                            break;
                        }
                        case 16: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "methodRef";
                            break;
                        }
                        case 17: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 18: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "uClass";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaUtilImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitEnumConstant";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitNamedExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitAnnotation";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitTypeReferenceExpression";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitVariable";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitSimpleNameReferenceExpression";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLiteralExpression";
                            break;
                        }
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPrefixExpression";
                            break;
                        }
                        case 8: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPostfixExpression";
                            break;
                        }
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitUnaryExpression";
                            break;
                        }
                        case 10: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitBinaryExpression";
                            break;
                        }
                        case 11: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitQualifiedReferenceExpression";
                            break;
                        }
                        case 12: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitObjectLiteralExpression";
                            break;
                        }
                        case 13: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitCallExpression";
                            break;
                        }
                        case 14: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                        case 15: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLambdaExpression";
                            break;
                        }
                        case 16: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitCallableReferenceExpression";
                            break;
                        }
                        case 17: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processFunctionalExpression";
                            break;
                        }
                        case 18: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClass";
                            break;
                        }
                        case 19: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReturnExpression";
                            break;
                        }
                        case 20: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClassLiteralExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static void addClassReferenceForStaticImport(UExpression node, PsiMember psiResolved, RefJavaElementImpl refFrom, UElement decl) {
        RefElement refContainingClass;
        PsiClass containingClass;
        PsiReferenceExpression ref;
        JavaResolveResult result;
        PsiElement sourcePsi = node.getSourcePsi();
        if (sourcePsi instanceof PsiReferenceExpression && (result = (ref = (PsiReferenceExpression)sourcePsi).advancedResolve(false)).getCurrentFileResolveScope() instanceof PsiImportStaticStatement && (containingClass = psiResolved.getContainingClass()) != null && (refContainingClass = refFrom.getRefManager().getReference((PsiElement)containingClass)) != null) {
            refContainingClass.initializeIfNeeded();
            refFrom.addReference(refContainingClass, (PsiElement)containingClass, decl, false, true, node);
        }
    }

    private void updateRefMethod(PsiElement psiResolved, RefMethodImpl refMethod, @NotNull UExpression uExpression, UElement uFrom) {
        if (uExpression == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(4);
        }
        UMethod uMethod = Objects.requireNonNull((UMethod)UastContextKt.toUElement((PsiElement)psiResolved, UMethod.class));
        refMethod.initializeIfNeeded();
        if (uExpression instanceof UCallableReferenceExpression) {
            UCallableReferenceExpression callableReference = (UCallableReferenceExpression)uExpression;
            PsiType returnType = uMethod.getReturnType();
            if (!uMethod.isConstructor()) {
                PsiType type = RefJavaUtilImpl.getFunctionalInterfaceType(callableReference);
                if (!PsiTypes.voidType().equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type))) {
                    refMethod.setReturnValueUsed(true);
                    this.addTypeReference(uFrom, returnType, (RefManager)refMethod.getRefManager());
                }
            }
            refMethod.setParametersAreUnknown();
            return;
        }
        if (uExpression instanceof ULiteralExpression) {
            PsiType returnType = uMethod.getReturnType();
            if (!uMethod.isConstructor() && !PsiTypes.voidType().equals((Object)returnType)) {
                refMethod.setReturnValueUsed(true);
                this.addTypeReference(uFrom, returnType, (RefManager)refMethod.getRefManager());
            }
            return;
        }
        PsiType returnType = uMethod.getReturnType();
        if (!uMethod.isConstructor() && !PsiTypes.voidType().equals((Object)returnType)) {
            PsiExpression expression;
            PsiElement type = uExpression.getJavaPsi();
            if (!(type instanceof PsiExpression) || !ExpressionUtils.isVoidContext(expression = (PsiExpression)type)) {
                refMethod.setReturnValueUsed(true);
            }
            this.addTypeReference(uFrom, returnType, (RefManager)refMethod.getRefManager());
        }
        UCallExpression call = null;
        if (uExpression instanceof UCallExpression) {
            UCallExpression callExpression;
            call = callExpression = (UCallExpression)uExpression;
        } else if (uExpression instanceof UQualifiedReferenceExpression) {
            UCallExpression c;
            UQualifiedReferenceExpression qualifiedReference = (UQualifiedReferenceExpression)uExpression;
            UExpression uExpression2 = qualifiedReference.getSelector();
            UCallExpression uCallExpression = call = uExpression2 instanceof UCallExpression ? (c = (UCallExpression)uExpression2) : null;
        }
        if (call != null) {
            Project project;
            PsiClassType methodOwnerType;
            String fqName;
            UClass containingClass;
            refMethod.updateParameterValues(call, psiResolved);
            PsiType usedType = call.getReceiverType();
            if (usedType != null && (containingClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)uMethod, UClass.class)) != null && (fqName = containingClass.getQualifiedName()) != null && !usedType.equals(methodOwnerType = JavaPsiFacade.getElementFactory((Project)(project = psiResolved.getProject())).createTypeByFQClassName(fqName, GlobalSearchScope.allScope((Project)project)))) {
                refMethod.setCalledOnSubClass(true);
            }
        }
    }

    private static PsiType getFunctionalInterfaceType(@NotNull UCallableReferenceExpression expression) {
        PsiElement psi;
        if (expression == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(5);
        }
        if ((psi = expression.getSourcePsi()) instanceof PsiFunctionalExpression) {
            PsiFunctionalExpression functionalExpression = (PsiFunctionalExpression)psi;
            return functionalExpression.getFunctionalInterfaceType();
        }
        return null;
    }

    public RefClass getTopLevelClass(@NotNull RefElement refElement) {
        RefClass refClass;
        if (refElement == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(refElement.isInitialized(), (Object)(refElement.getName() + " not initialized"));
        RefEntity refParent = refElement.getOwner();
        while (refParent instanceof RefElement && !(refParent instanceof RefFile)) {
            refElement = (RefElement)refParent;
            refParent = refParent.getOwner();
        }
        return refElement instanceof RefClass ? (refClass = (RefClass)refElement) : null;
    }

    public boolean isInheritor(@NotNull RefClass subClass, RefClass superClass) {
        if (subClass == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(7);
        }
        if (subClass == superClass) {
            return true;
        }
        LOG.assertTrue(subClass.isInitialized());
        for (RefClass baseClass : subClass.getBaseClasses()) {
            if (!this.isInheritor(baseClass, superClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getPackageName(RefEntity refEntity) {
        if (refEntity instanceof RefProject || refEntity instanceof RefJavaModule) {
            return null;
        }
        if (!(refEntity instanceof RefJavaElement || refEntity instanceof RefPackage || refEntity instanceof RefJavaFileImpl)) {
            return null;
        }
        RefPackage refPackage = RefJavaUtilImpl.getPackage((RefEntity)refEntity);
        return refPackage == null ? JavaAnalysisBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]) : refPackage.getQualifiedName();
    }

    @NotNull
    public String getAccessModifier(@NotNull PsiModifierListOwner psiElement) {
        if (psiElement == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(8);
        }
        if (psiElement instanceof PsiParameter) {
            return "packageLocal";
        }
        PsiModifierList list = psiElement.getModifierList();
        String result = "packageLocal";
        if (list != null) {
            if (list.hasModifierProperty("private")) {
                result = "private";
            } else if (list.hasModifierProperty("protected")) {
                result = "protected";
            } else if (list.hasModifierProperty("public")) {
                result = "public";
            } else {
                PsiClass ownerClass;
                PsiElement psiElement2 = psiElement.getParent();
                if (psiElement2 instanceof PsiClass && (ownerClass = (PsiClass)psiElement2).isInterface()) {
                    result = "public";
                }
            }
        }
        String string = result;
        if (string == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public RefClass getOwnerClass(RefManager refManager, UElement uElement) {
        while (uElement != null && !(uElement instanceof UClass)) {
            uElement = uElement.getUastParent();
        }
        if (uElement != null) {
            RefClass refClass;
            RefElement reference = refManager.getReference(uElement.getSourcePsi());
            return reference instanceof RefClass ? (refClass = (RefClass)reference) : null;
        }
        return null;
    }

    @Nullable
    public RefClass getOwnerClass(RefElement refElement) {
        RefClass refClass;
        LOG.assertTrue(refElement.isInitialized(), (Object)(refElement.getName() + " not initialized"));
        RefEntity parent = refElement.getOwner();
        while (!(parent instanceof RefClass) && parent instanceof RefElement) {
            LOG.assertTrue(((RefElement)parent).isInitialized());
            parent = parent.getOwner();
        }
        return parent instanceof RefClass ? (refClass = (RefClass)parent) : null;
    }

    public boolean isMethodOnlyCallsSuper(UMethod method) {
        PsiMethod javaMethod = method.getJavaPsi();
        boolean hasStatements = false;
        UExpression body = method.getUastBody();
        if (body != null) {
            List statements;
            if (body instanceof UBlockExpression) {
                PsiMethod[] blockExpression = (PsiMethod[])body;
                v0 = blockExpression.getExpressions();
            } else {
                v0 = statements = Collections.singletonList(body);
            }
            if (statements.size() > 1) {
                return false;
            }
            for (UExpression expression : statements) {
                boolean isCallToSameSuper = false;
                if (expression instanceof UReturnExpression) {
                    UReturnExpression returnExpression = (UReturnExpression)expression;
                    UExpression returnExpr = returnExpression.getReturnExpression();
                    isCallToSameSuper = returnExpr == null || this.isCallToSuperMethod(returnExpr, method);
                } else if (!(expression instanceof UBlockExpression)) {
                    isCallToSameSuper = this.isCallToSuperMethod(expression, method);
                }
                hasStatements = true;
                if (isCallToSameSuper) continue;
                return false;
            }
        }
        if (hasStatements) {
            PsiMethod[] superMethods = javaMethod.findSuperMethods();
            for (PsiMethod superMethod : superMethods) {
                if (VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)superMethod.getModifierList()), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)javaMethod.getModifierList())) <= 0) continue;
                return false;
            }
            PsiClass aClass = javaMethod.getContainingClass();
            if (aClass == null || RefJavaUtilImpl.hasUnrelatedDefaults(aClass, Arrays.asList(superMethods))) {
                return false;
            }
        }
        return hasStatements;
    }

    public boolean isCallToSuperMethod(UExpression expression, UMethod method) {
        if (expression instanceof UQualifiedReferenceExpression) {
            UQualifiedReferenceExpression qualifiedReference = (UQualifiedReferenceExpression)expression;
            UExpression receiver = qualifiedReference.getReceiver();
            UExpression selector = qualifiedReference.getSelector();
            if (receiver instanceof USuperExpression && selector instanceof UCallExpression) {
                UCallExpression callExpression = (UCallExpression)selector;
                PsiMethod superMethod = callExpression.resolve();
                if (superMethod == null || !MethodSignatureUtil.areSignaturesEqual((PsiMethod)method.getJavaPsi(), (PsiMethod)superMethod)) {
                    return false;
                }
                List args = callExpression.getValueArguments();
                List params = method.getUastParameters();
                for (int i = 0; i < args.size(); ++i) {
                    UExpression arg = (UExpression)args.get(i);
                    if (!(arg instanceof USimpleNameReferenceExpression)) {
                        return false;
                    }
                    USimpleNameReferenceExpression simpleNameReference = (USimpleNameReferenceExpression)arg;
                    if (((UParameter)params.get(i)).equals((Object)simpleNameReference.resolve())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int compareAccess(String a1, String a2) {
        return Integer.compare(RefJavaUtilImpl.getAccessNumber(a1), RefJavaUtilImpl.getAccessNumber(a2));
    }

    private static int getAccessNumber(String modifier) {
        return switch (modifier) {
            case "private" -> 0;
            case "packageLocal" -> 1;
            case "protected" -> 2;
            case "public" -> 3;
            default -> -1;
        };
    }

    public void setAccessModifier(@NotNull RefJavaElement refElement, @NotNull String newAccess) {
        if (refElement == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(10);
        }
        if (newAccess == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(11);
        }
        ((RefJavaElementImpl)refElement).setAccessModifier(newAccess);
    }

    public void setIsStatic(RefJavaElement refElement, boolean isStatic) {
        ((RefJavaElementImpl)refElement).setIsStatic(isStatic);
    }

    public void setIsFinal(RefJavaElement refElement, boolean isFinal) {
        ((RefJavaElementImpl)refElement).setIsFinal(isFinal);
    }

    public void addTypeReference(UElement uElement, PsiType psiType, RefManager refManager) {
        this.addTypeReference(uElement, psiType, refManager, null);
    }

    public void addTypeReference(UElement uElement, PsiType psiType, RefManager refManager, @Nullable RefJavaElement refMethod) {
        if (!(psiType instanceof PsiClassType)) {
            return;
        }
        RefClass ownerClass = this.getOwnerClass(refManager, uElement);
        if (ownerClass == null) {
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)(psiType = psiType.getDeepComponentType()));
        if (psiClass != null && refManager.belongsToScope((PsiElement)psiClass)) {
            RefClassImpl refClass = (RefClassImpl)refManager.getReference((PsiElement)psiClass);
            if (refClass != null) {
                refClass.addTypeReference((RefJavaElement)ownerClass);
                if (refMethod != null) {
                    refClass.addClassExporter(refMethod);
                }
            }
        } else {
            ((RefManagerImpl)refManager).fireNodeMarkedReferenced((PsiElement)psiClass, uElement.getSourcePsi());
        }
    }

    private static boolean isAccessedForWriting(@NotNull UElement expression) {
        if (expression == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(12);
        }
        if (RefJavaUtilImpl.isOnAssignmentLeftHand(expression)) {
            return true;
        }
        UElement parent = RefJavaUtilImpl.skipParentheses(expression);
        return RefJavaUtilImpl.isIncrementDecrement(parent);
    }

    private static boolean isIncrementDecrement(UElement element) {
        if (!(element instanceof UUnaryExpression)) {
            return false;
        }
        UUnaryExpression unaryExpression = (UUnaryExpression)element;
        UastOperator operator = unaryExpression.getOperator();
        return operator == UastPostfixOperator.DEC || operator == UastPostfixOperator.INC || operator == UastPrefixOperator.DEC || operator == UastPrefixOperator.INC;
    }

    private static boolean isAccessedForReading(@NotNull UElement expression) {
        UBinaryExpression binaryExpression;
        UElement parent;
        if (expression == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(13);
        }
        return !((parent = RefJavaUtilImpl.skipParentheses(expression)) instanceof UBinaryExpression) || (binaryExpression = (UBinaryExpression)parent).getOperator() != UastBinaryOperator.ASSIGN || UastUtils.isUastChildOf((UElement)binaryExpression.getRightOperand(), (UElement)expression, (boolean)false);
    }

    private static boolean isOnAssignmentLeftHand(@NotNull UElement expression) {
        UBinaryExpression binaryExpression;
        UElement uElement;
        if (expression == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(14);
        }
        if (!((uElement = RefJavaUtilImpl.skipParentheses(expression)) instanceof UExpression)) {
            return false;
        }
        UExpression parent = (UExpression)uElement;
        return parent instanceof UBinaryExpression && (binaryExpression = (UBinaryExpression)parent).getOperator() instanceof UastBinaryOperator.AssignOperator && UastUtils.isUastChildOf((UElement)expression, (UElement)binaryExpression.getLeftOperand(), (boolean)false);
    }

    private static UElement skipParentheses(@NotNull UElement expression) {
        if (expression == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(15);
        }
        return UastUtils.skipParentOfType((UElement)expression, (boolean)true, (Class[])new Class[]{UParenthesizedExpression.class});
    }

    public static PsiElement returnToPhysical(PsiElement element) {
        if (element instanceof LightElement) {
            PsiElement el;
            UElement uElement = UastContextKt.toUElement((PsiElement)element);
            PsiElement psiElement = el = uElement == null ? null : uElement.getSourcePsi();
            if (el != null) {
                return el;
            }
            return element.getNavigationElement();
        }
        return element;
    }

    private static boolean hasUnrelatedDefaults(@NotNull PsiClass aClass, @NotNull Collection<? extends PsiMethod> overrideEquivalentSuperMethods) {
        if (aClass == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(16);
        }
        if (overrideEquivalentSuperMethods == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(17);
        }
        return JavaPsiMethodUtil.getAbstractMethodToImplementWhenDefaultPresent((PsiClass)aClass, overrideEquivalentSuperMethods, (boolean)true) != null || JavaPsiMethodUtil.getUnrelatedSuperMethods((PsiClass)aClass, overrideEquivalentSuperMethods) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFrom";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uExpression";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefJavaUtilImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAccess";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrideEquivalentSuperMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaUtilImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addReferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addReferencesTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateRefMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionalInterfaceType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAccessModifier";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setAccessModifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForWriting";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForReading";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isOnAssignmentLeftHand";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "skipParentheses";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasUnrelatedDefaults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

