/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class InstanceofThisInspection
extends BaseInspection {
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.exactInstanceCall("java.lang.Object", "getClass").parameterCount(0);

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message(infos[0] instanceof PsiInstanceOfExpression ? "instanceof.check.for.this.problem.descriptor" : "instanceof.check.for.this.equality.problem.descriptor", new Object[0]);
        if (string == null) {
            InstanceofThisInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofThisVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofThisInspection", "buildErrorString"));
    }

    private static class InstanceofThisVisitor
    extends BaseInspectionVisitor {
        private InstanceofThisVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiExpression compared;
            PsiExpression qualifier;
            if (call == null) {
                InstanceofThisVisitor.$$$reportNull$$$0(0);
            }
            if (OBJECT_GET_CLASS.test(call) && (qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression())) != null && StreamEx.of(ExpressionUtils.nonStructuralChildren(qualifier)).select(PsiThisExpression.class).anyMatch(thisExpression -> thisExpression.getQualifier() == null) && (compared = ExpressionUtils.getExpressionComparedTo((PsiExpression)call)) instanceof PsiClassObjectAccessExpression) {
                this.registerError((PsiElement)(qualifier.isPhysical() ? qualifier : call), call);
            }
        }

        public void visitThisExpression(@NotNull PsiThisExpression thisValue) {
            if (thisValue == null) {
                InstanceofThisVisitor.$$$reportNull$$$0(1);
            }
            super.visitThisExpression(thisValue);
            if (thisValue.getQualifier() != null) {
                return;
            }
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)thisValue, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiConditionalExpression.class, PsiTypeCastExpression.class});
            if (!(parent instanceof PsiInstanceOfExpression)) {
                return;
            }
            this.registerError((PsiElement)thisValue, parent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisValue";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/abstraction/InstanceofThisInspection$InstanceofThisVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThisExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

