/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseEqualsVisitor
extends BaseInspectionVisitor {
    static final CallMatcher OBJECT_EQUALS = CallMatcher.instanceCall("java.lang.Object", "equals").parameterTypes("java.lang.Object");
    private static final CallMatcher STATIC_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2));
    private static final CallMatcher PREDICATE_TEST = CallMatcher.instanceCall("java.util.function.Predicate", "test").parameterCount(1);
    private static final CallMatcher PREDICATE_IS_EQUAL = CallMatcher.staticCall("java.util.function.Predicate", "isEqual").parameterCount(1);
    private static final CallMatcher PREDICATE_NOT = CallMatcher.staticCall("java.util.function.Predicate", "not").parameterCount(1);
    private static final CallMatcher PREDICATE_OR = CallMatcher.instanceCall("java.util.function.Predicate", "or").parameterCount(1);
    private static final CallMatcher PREDICATE_AND = CallMatcher.instanceCall("java.util.function.Predicate", "and").parameterCount(1);
    private static final CallMatcher PREDICATE_NEGATE = CallMatcher.instanceCall("java.util.function.Predicate", "negate").parameterCount(0);
    private static final CallMatcher PREDICATE_NOT_OR_AND = CallMatcher.anyOf(PREDICATE_NOT, PREDICATE_OR, PREDICATE_AND);
    private static final CallMatcher PREDICATE_OR_AND_NEGATE = CallMatcher.anyOf(PREDICATE_OR, PREDICATE_AND, PREDICATE_NEGATE);

    BaseEqualsVisitor() {
    }

    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
        PsiType rightType;
        PsiType leftType;
        if (expression == null) {
            BaseEqualsVisitor.$$$reportNull$$$0(0);
        }
        super.visitMethodReferenceExpression(expression);
        if (!OBJECT_EQUALS.methodReferenceMatches(expression) && !STATIC_EQUALS.methodReferenceMatches(expression)) {
            return;
        }
        PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
        if (method == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)method, (PsiClassType.ClassResolveResult)resolveResult);
        if (parameters.length == 2) {
            leftType = substitutor.substitute(parameters[0].getType());
            rightType = substitutor.substitute(parameters[1].getType());
        } else {
            PsiExpression qualifier = expression.getQualifierExpression();
            assert (qualifier != null);
            leftType = qualifier.getType();
            rightType = substitutor.substitute(parameters[0].getType());
        }
        if (leftType != null && rightType != null) {
            this.checkTypes((PsiReferenceExpression)expression, leftType, rightType);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            BaseEqualsVisitor.$$$reportNull$$$0(1);
        }
        super.visitMethodCallExpression(expression);
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        if (OBJECT_EQUALS.test(expression)) {
            PsiExpression expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getEffectiveQualifier(expression.getMethodExpression()));
            PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            this.checkTypes(expression, expression1, expression2);
        } else if (STATIC_EQUALS.test(expression)) {
            PsiExpression expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[1]);
            this.checkTypes(expression, expression1, expression2);
        } else if (PREDICATE_IS_EQUAL.test(expression)) {
            PsiExpression expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            PsiType psiType1 = BaseEqualsVisitor.getType(expression1);
            PsiType psiType2 = BaseEqualsVisitor.resolveIsEqualPredicateType(expression);
            if (psiType1 == null || psiType2 == null) {
                return;
            }
            this.checkTypes(expression.getMethodExpression(), psiType1, psiType2);
        }
    }

    @Nullable
    private static PsiType resolveIsEqualPredicateType(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            BaseEqualsVisitor.$$$reportNull$$$0(2);
        }
        PsiMethodCallExpression highestPredicate = expression;
        int max = 100;
        for (int currentLevel = 0; currentLevel <= max; ++currentLevel) {
            PsiExpression psiExpressionNextParent;
            PsiElement psiElement;
            PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)highestPredicate);
            if (PREDICATE_OR_AND_NEGATE.matches((PsiExpression)call)) {
                highestPredicate = call;
                continue;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)highestPredicate.getParent());
            if (!(parent instanceof PsiExpressionList) || !((psiElement = parent.getParent()) instanceof PsiExpression) || !PREDICATE_NOT_OR_AND.matches(psiExpressionNextParent = (PsiExpression)psiElement)) break;
            highestPredicate = psiExpressionNextParent;
        }
        return BaseEqualsVisitor.findPsiTypeForPredicate((PsiExpression)highestPredicate);
    }

    @Nullable
    private static PsiType findPsiTypeForPredicate(@NotNull PsiExpression predicate) {
        PsiType typeParameter;
        if (predicate == null) {
            BaseEqualsVisitor.$$$reportNull$$$0(3);
        }
        if ((typeParameter = PsiUtil.substituteTypeParameter((PsiType)predicate.getType(), (String)"java.util.function.Predicate", (int)0, (boolean)false)) != null && !typeParameter.equalsToText("java.lang.Object")) {
            return typeParameter;
        }
        PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier(predicate);
        if (PREDICATE_TEST.test(call)) {
            PsiExpression[] argumentExpressions = call.getArgumentList().getExpressions();
            if (argumentExpressions.length != 1) {
                return null;
            }
            PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)argumentExpressions[0]);
            return BaseEqualsVisitor.getType(argument);
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)predicate.getParent());
        if (parent instanceof PsiExpressionList) {
            return BaseEqualsVisitor.findPredicateExpectedType(predicate);
        }
        return null;
    }

    @Nullable
    private static PsiType findPredicateExpectedType(@NotNull PsiExpression predicate) {
        PsiType expectedType;
        if (predicate == null) {
            BaseEqualsVisitor.$$$reportNull$$$0(4);
        }
        if (!((expectedType = ExpectedTypeUtils.findExpectedType(predicate, true)) instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)expectedType;
        if (classType.getParameterCount() != 1 || !PsiTypesUtil.classNameEquals((PsiType)classType, (String)"java.util.function.Predicate")) {
            return null;
        }
        PsiType parameter = classType.getParameters()[0];
        if (parameter == null || parameter.equalsToText("java.lang.Object")) {
            return null;
        }
        if (parameter instanceof PsiWildcardType) {
            PsiWildcardType psiWildcardType = (PsiWildcardType)parameter;
            parameter = psiWildcardType.isSuper() ? psiWildcardType.getSuperBound() : parameter;
        }
        return parameter;
    }

    private void checkTypes(@NotNull PsiMethodCallExpression expression, PsiExpression expression1, PsiExpression expression2) {
        CommonDataflow.DataflowResult dfa;
        if (expression == null) {
            BaseEqualsVisitor.$$$reportNull$$$0(5);
        }
        if (expression1 == null || expression2 == null) {
            return;
        }
        PsiType leftType = BaseEqualsVisitor.getType(expression1);
        PsiType rightType = BaseEqualsVisitor.getType(expression2);
        if (leftType != null && rightType != null && !this.checkTypes(expression.getMethodExpression(), leftType, rightType) && (dfa = CommonDataflow.getDataflowResult((PsiElement)expression)) != null) {
            PsiType refinedRightType;
            Project project = this.getCurrentFile().getProject();
            PsiType refinedLeftType = leftType instanceof PsiPrimitiveType ? leftType : TypeConstraint.fromDfType(dfa.getDfType(expression1)).getPsiType(project);
            PsiType psiType = refinedRightType = rightType instanceof PsiPrimitiveType ? rightType : TypeConstraint.fromDfType(dfa.getDfType(expression2)).getPsiType(project);
            if (!(refinedLeftType == null || refinedRightType == null || refinedLeftType.equals(leftType) && refinedRightType.equals(rightType))) {
                this.checkTypes(expression.getMethodExpression(), refinedLeftType, refinedRightType);
            }
        }
    }

    protected static PsiType getType(PsiExpression expression) {
        if (!(expression instanceof PsiNewExpression)) {
            return expression.getType();
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        return anonymousClass != null ? anonymousClass.getBaseClassType() : expression.getType();
    }

    abstract boolean checkTypes(@NotNull PsiReferenceExpression var1, @NotNull PsiType var2, @NotNull PsiType var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/bugs/BaseEqualsVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveIsEqualPredicateType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findPsiTypeForPredicate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findPredicateExpectedType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

