/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class MathRandomCastToIntInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[1];
        String string = InspectionGadgetsBundle.message("math.random.cast.to.int.problem.descriptor", type.getPresentableText());
        if (string == null) {
            MathRandomCastToIntInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiTypeCastExpression expression = (PsiTypeCastExpression)infos[0];
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (JavaTokenType.ASTERISK != tokenType || polyadicExpression.getType() == null) {
            return null;
        }
        return new MathRandomCastToIntegerFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MathRandomCastToIntegerVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MathRandomCastToIntInspection", "buildErrorString"));
    }

    private static class MathRandomCastToIntegerFix
    extends PsiUpdateModCommandQuickFix {
        private MathRandomCastToIntegerFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("math.random.cast.to.int.quickfix", new Object[0]);
            if (string == null) {
                MathRandomCastToIntegerFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpression[] operands;
            if (project == null) {
                MathRandomCastToIntegerFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MathRandomCastToIntegerFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MathRandomCastToIntegerFix.$$$reportNull$$$0(3);
            }
            PsiElement parent = element.getParent();
            while (parent instanceof PsiPrefixExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiElement grandParent = typeCastExpression.getParent();
            if (!(grandParent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)grandParent;
            PsiExpression operand = typeCastExpression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType type = polyadicExpression.getType();
            if (type == null) {
                return;
            }
            @NonNls StringBuilder newExpression = new StringBuilder();
            CommentTracker commentTracker = new CommentTracker();
            newExpression.append("(").append(type.getCanonicalText()).append(")(");
            for (PsiExpression expression : operands = polyadicExpression.getOperands()) {
                PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(expression);
                if (token != null) {
                    newExpression.append(token.getText());
                }
                if (typeCastExpression.equals((Object)expression)) {
                    newExpression.append(commentTracker.text((PsiElement)operand));
                    continue;
                }
                newExpression.append(commentTracker.text((PsiElement)expression));
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/MathRandomCastToIntInspection$MathRandomCastToIntegerFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/MathRandomCastToIntInspection$MathRandomCastToIntegerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MathRandomCastToIntegerVisitor
    extends BaseInspectionVisitor {
        private MathRandomCastToIntegerVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                MathRandomCastToIntegerVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeCastExpression(expression);
            PsiExpression operand = expression.getOperand();
            while (operand instanceof PsiPrefixExpression) {
                operand = ((PsiPrefixExpression)operand).getOperand();
            }
            if (!(operand instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand;
            PsiTypeElement castType = expression.getCastType();
            if (castType == null) {
                return;
            }
            PsiType type = castType.getType();
            if (!(type instanceof PsiPrimitiveType) || PsiTypes.doubleType().equals((Object)type) || PsiTypes.floatType().equals((Object)type) || PsiTypes.booleanType().equals((Object)type)) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            @NonNls String referenceName = methodExpression.getReferenceName();
            if (!"random".equals(referenceName)) {
                return;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.lang.Math".equals(qualifiedName) && !"java.lang.StrictMath".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)methodCallExpression, expression, type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/MathRandomCastToIntInspection$MathRandomCastToIntegerVisitor", "visitTypeCastExpression"));
        }
    }
}

