/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class SuspiciousArrayCastInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("suspicious.array.cast.problem.descriptor", new Object[0]);
        if (string == null) {
            SuspiciousArrayCastInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousArrayCastVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousArrayCastInspection", "buildErrorString"));
    }

    private static class SuspiciousArrayCastVisitor
    extends BaseInspectionVisitor {
        private SuspiciousArrayCastVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                SuspiciousArrayCastVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeCastExpression(expression);
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castType = typeElement.getType();
            if (!(castType instanceof PsiArrayType)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType type = operand.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            PsiClass castClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)castType.getDeepComponentType());
            if (castClass == null) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type.getDeepComponentType());
            if (aClass == null || !castClass.isInheritor(aClass, true) || SuspiciousArrayCastVisitor.isCollectionToArrayCall(operand)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        private static boolean isCollectionToArrayCall(PsiExpression expression) {
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressionCount() != 1) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if (!"toArray".equals(methodExpression.getReferenceName())) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/SuspiciousArrayCastInspection$SuspiciousArrayCastVisitor", "visitTypeCastExpression"));
        }
    }
}

