/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ListenerMayUseAdapterInspection
extends BaseInspection {
    public boolean checkForEmptyMethods = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        String adapterName = (String)infos[1];
        String string = InspectionGadgetsBundle.message("listener.may.use.adapter.problem.descriptor", className, adapterName);
        if (string == null) {
            ListenerMayUseAdapterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"checkForEmptyMethods", (String)InspectionGadgetsBundle.message("listener.may.use.adapter.emtpy.methods.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ListenerMayUseAdapterInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        String adapterName = (String)infos[1];
        return new ListenerMayUseAdapterFix(adapterName);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ListenerMayUseAdapterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/ListenerMayUseAdapterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ListenerMayUseAdapterFix
    extends PsiUpdateModCommandQuickFix {
        private final String adapterName;

        ListenerMayUseAdapterFix(@NotNull String adapterName) {
            if (adapterName == null) {
                ListenerMayUseAdapterFix.$$$reportNull$$$0(0);
            }
            this.adapterName = adapterName;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"extends " + this.adapterName});
            if (string == null) {
                ListenerMayUseAdapterFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("listener.may.use.adapter.fix.family.name", new Object[0]);
            if (string == null) {
                ListenerMayUseAdapterFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiJavaCodeReferenceElement element;
            PsiClass aClass;
            if (project == null) {
                ListenerMayUseAdapterFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ListenerMayUseAdapterFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ListenerMayUseAdapterFix.$$$reportNull$$$0(5);
            }
            if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(element = (PsiJavaCodeReferenceElement)startElement), PsiClass.class)) == null) {
                return;
            }
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length > 0) {
                PsiElement target = element.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                PsiClass interfaceClass = (PsiClass)target;
                for (PsiMethod method : methods) {
                    PsiMethod[] superMethods;
                    if (!ControlFlowUtils.isEmptyCodeBlock(method.getBody()) || (superMethods = method.findSuperMethods(interfaceClass)).length <= 0) continue;
                    method.delete();
                }
            }
            element.delete();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass adapterClass = psiFacade.findClass(this.adapterName, aClass.getResolveScope());
            if (adapterClass == null) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = psiFacade.getElementFactory().createClassReferenceElement(adapterClass);
            extendsList.add((PsiElement)referenceElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "adapterName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/classlayout/ListenerMayUseAdapterInspection$ListenerMayUseAdapterFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/classlayout/ListenerMayUseAdapterInspection$ListenerMayUseAdapterFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private class ListenerMayUseAdapterVisitor
    extends BaseInspectionVisitor {
        private ListenerMayUseAdapterVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiJavaCodeReferenceElement[] implementsReferences;
            PsiReferenceList extendsList;
            if (aClass == null) {
                ListenerMayUseAdapterVisitor.$$$reportNull$$$0(0);
            }
            if ((extendsList = aClass.getExtendsList()) == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] extendsReferences = extendsList.getReferenceElements();
            if (extendsReferences.length > 0) {
                return;
            }
            PsiReferenceList implementsList = aClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement implementsReference : implementsReferences = implementsList.getReferenceElements()) {
                this.checkReference(aClass, implementsReference);
            }
        }

        private void checkReference(@NotNull PsiClass aClass, @NotNull PsiJavaCodeReferenceElement implementsReference) {
            PsiElement target;
            if (aClass == null) {
                ListenerMayUseAdapterVisitor.$$$reportNull$$$0(1);
            }
            if (implementsReference == null) {
                ListenerMayUseAdapterVisitor.$$$reportNull$$$0(2);
            }
            if (!((target = implementsReference.resolve()) instanceof PsiClass)) {
                return;
            }
            PsiClass implementsClass = (PsiClass)target;
            @NonNls String className = implementsClass.getQualifiedName();
            if (className == null || !className.endsWith("Listener")) {
                return;
            }
            PsiMethod[] interfaceMethods = implementsClass.getMethods();
            if (interfaceMethods.length < 2) {
                return;
            }
            boolean allDefault = true;
            for (PsiMethod interfaceMethod : interfaceMethods) {
                if (interfaceMethod.hasModifierProperty("default")) continue;
                allDefault = false;
                break;
            }
            if (allDefault) {
                return;
            }
            @NonNls String adapterName = className.substring(0, className.length() - 8) + "Adapter";
            GlobalSearchScope scope = implementsClass.getResolveScope();
            PsiClass adapterClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(adapterName, scope);
            if (adapterClass == null || adapterClass.equals((Object)aClass) || !adapterClass.hasModifierProperty("abstract") || adapterClass.isDeprecated()) {
                return;
            }
            PsiReferenceList implementsList = adapterClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] referenceElements = implementsList.getReferenceElements();
            boolean adapterImplementsListener = false;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
                PsiElement implementsTarget = referenceElement.resolve();
                if (!implementsClass.equals((Object)implementsTarget)) continue;
                adapterImplementsListener = true;
            }
            if (!adapterImplementsListener) {
                return;
            }
            if (ListenerMayUseAdapterInspection.this.checkForEmptyMethods) {
                PsiMethod[] methods;
                boolean emptyMethodFound = false;
                for (PsiMethod method : methods = aClass.getMethods()) {
                    PsiMethod[] superMethods;
                    PsiCodeBlock body = method.getBody();
                    if (!ControlFlowUtils.isEmptyCodeBlock(body) || (superMethods = method.findSuperMethods(implementsClass)).length == 0) continue;
                    emptyMethodFound = true;
                    break;
                }
                if (!emptyMethodFound) {
                    return;
                }
            }
            this.registerError((PsiElement)implementsReference, aClass, adapterName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implementsReference";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/classlayout/ListenerMayUseAdapterInspection$ListenerMayUseAdapterVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

