/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import org.jetbrains.annotations.NotNull;

public final class UtilityClassWithPublicConstructorInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("utility.class.with.public.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            UtilityClassWithPublicConstructorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiClass psiClass = (PsiClass)infos[0];
        boolean hasInheritors = (Boolean)infos[1];
        return new UtilityClassWithPublicConstructorFix(psiClass.getConstructors().length > 1, hasInheritors);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StaticClassWithPublicConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/UtilityClassWithPublicConstructorInspection", "buildErrorString"));
    }

    private static class UtilityClassWithPublicConstructorFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean m_multipleConstructors;
        private final boolean m_hasInheritors;

        UtilityClassWithPublicConstructorFix(boolean multipleConstructors, boolean hasInheritors) {
            this.m_multipleConstructors = multipleConstructors;
            this.m_hasInheritors = hasInheritors;
        }

        @NotNull
        public String getName() {
            String string = this.m_hasInheritors ? InspectionGadgetsBundle.message("utility.class.with.public.constructor.make.protected.quickfix", this.m_multipleConstructors ? 2 : 1) : InspectionGadgetsBundle.message("utility.class.with.public.constructor.make.private.quickfix", this.m_multipleConstructors ? 2 : 1);
            if (string == null) {
                UtilityClassWithPublicConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("utility.class.with.public.constructor.fix.family.name", new Object[0]);
            if (string == null) {
                UtilityClassWithPublicConstructorFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement classNameIdentifier, @NotNull ModPsiUpdater updater) {
            PsiClass psiClass;
            if (project == null) {
                UtilityClassWithPublicConstructorFix.$$$reportNull$$$0(2);
            }
            if (classNameIdentifier == null) {
                UtilityClassWithPublicConstructorFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                UtilityClassWithPublicConstructorFix.$$$reportNull$$$0(4);
            }
            if ((psiClass = (PsiClass)classNameIdentifier.getParent()) == null) {
                return;
            }
            String modifier = this.m_hasInheritors ? "protected" : "private";
            for (PsiMethod constructor : psiClass.getConstructors()) {
                constructor.getModifierList().setModifierProperty(modifier, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/classlayout/UtilityClassWithPublicConstructorInspection$UtilityClassWithPublicConstructorFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classNameIdentifier";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/classlayout/UtilityClassWithPublicConstructorInspection$UtilityClassWithPublicConstructorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class StaticClassWithPublicConstructorVisitor
    extends BaseInspectionVisitor {
        private StaticClassWithPublicConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                StaticClassWithPublicConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (!UtilityClassUtil.isUtilityClass(aClass) || !StaticClassWithPublicConstructorVisitor.hasPublicConstructor(aClass)) {
                return;
            }
            boolean hasInheritors = ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)false).findFirst() != null;
            this.registerClassError(aClass, aClass, hasInheritors);
        }

        private static boolean hasPublicConstructor(PsiClass aClass) {
            for (PsiMethod constructor : aClass.getConstructors()) {
                if (!constructor.hasModifierProperty("public")) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/UtilityClassWithPublicConstructorInspection$StaticClassWithPublicConstructorVisitor", "visitClass"));
        }
    }
}

