/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CyclomaticComplexityVisitor
extends JavaRecursiveElementWalkingVisitor {
    private int m_complexity = 1;

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(0);
        }
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(1);
        }
        super.visitForStatement(statement);
        ++this.m_complexity;
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(2);
        }
        super.visitForeachStatement(statement);
        ++this.m_complexity;
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(3);
        }
        super.visitIfStatement(statement);
        ++this.m_complexity;
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(4);
        }
        super.visitDoWhileStatement(statement);
        ++this.m_complexity;
    }

    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
        if (expression == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(5);
        }
        super.visitConditionalExpression(expression);
        ++this.m_complexity;
    }

    public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
        if (expression == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(6);
        }
        super.visitSwitchExpression(expression);
        this.visitSwitchBlock((PsiSwitchBlock)expression);
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(7);
        }
        super.visitSwitchStatement(statement);
        this.visitSwitchBlock((PsiSwitchBlock)statement);
    }

    private void visitSwitchBlock(PsiSwitchBlock statement) {
        PsiCodeBlock body = statement.getBody();
        if (body == null) {
            return;
        }
        boolean pendingLabel = false;
        for (PsiStatement child : body.getStatements()) {
            if (child instanceof PsiSwitchLabelStatement) {
                pendingLabel = !((PsiSwitchLabelStatement)child).isDefaultCase();
                continue;
            }
            if (child instanceof PsiSwitchLabeledRuleStatement && !((PsiSwitchLabeledRuleStatement)child).isDefaultCase()) {
                ++this.m_complexity;
                continue;
            }
            if (!pendingLabel) continue;
            ++this.m_complexity;
            pendingLabel = false;
        }
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(8);
        }
        super.visitWhileStatement(statement);
        ++this.m_complexity;
    }

    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(9);
        }
        super.visitPolyadicExpression(expression);
        IElementType token = expression.getOperationTokenType();
        if (token.equals(JavaTokenType.ANDAND) || token.equals(JavaTokenType.OROR)) {
            this.m_complexity += expression.getOperands().length - 1;
        }
    }

    public void visitCatchSection(@NotNull PsiCatchSection section) {
        if (section == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(10);
        }
        super.visitCatchSection(section);
        ++this.m_complexity;
    }

    public int getComplexity() {
        return this.m_complexity;
    }

    public void reset() {
        this.m_complexity = 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/classmetrics/CyclomaticComplexityVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnonymousClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForeachStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIfStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDoWhileStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditionalExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhileStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPolyadicExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCatchSection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

