/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class CloneDeclaresCloneNotSupportedInspection
extends BaseInspection {
    public boolean onlyWarnOnProtectedClone = true;

    @NotNull
    public String getID() {
        return "CloneDoesntDeclareCloneNotSupportedException";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.problem.descriptor", new Object[0]);
        if (string == null) {
            CloneDeclaresCloneNotSupportedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyWarnOnProtectedClone", (String)InspectionGadgetsBundle.message("only.warn.on.protected.clone.methods", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            CloneDeclaresCloneNotSupportedInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            CloneDeclaresCloneNotSupportedInspection.$$$reportNull$$$0(2);
        }
        this.writeBooleanOption(node, "onlyWarnOnProtectedClone", true);
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new CloneDeclaresCloneNotSupportedInspectionFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CloneDeclaresCloneNotSupportedExceptionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class CloneDeclaresCloneNotSupportedInspectionFix
    extends PsiUpdateModCommandQuickFix {
        private CloneDeclaresCloneNotSupportedInspectionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.declare.quickfix", new Object[0]);
            if (string == null) {
                CloneDeclaresCloneNotSupportedInspectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement methodNameIdentifier, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                CloneDeclaresCloneNotSupportedInspectionFix.$$$reportNull$$$0(1);
            }
            if (methodNameIdentifier == null) {
                CloneDeclaresCloneNotSupportedInspectionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                CloneDeclaresCloneNotSupportedInspectionFix.$$$reportNull$$$0(3);
            }
            PsiMethod method = (PsiMethod)methodNameIdentifier.getParent();
            PsiUtil.addException((PsiMethod)method, (String)"java.lang.CloneNotSupportedException");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedInspectionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameIdentifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedInspectionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class CloneDeclaresCloneNotSupportedExceptionVisitor
    extends BaseInspectionVisitor {
        private CloneDeclaresCloneNotSupportedExceptionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                CloneDeclaresCloneNotSupportedExceptionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!CloneUtils.isClone(method)) {
                return;
            }
            if (method.hasModifierProperty("final")) {
                return;
            }
            if (CloneDeclaresCloneNotSupportedInspection.this.onlyWarnOnProtectedClone && method.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            if (MethodUtils.hasInThrows(method, "java.lang.CloneNotSupportedException")) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod != null && !MethodUtils.hasInThrows(superMethod, "java.lang.CloneNotSupportedException")) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedExceptionVisitor", "visitMethod"));
        }
    }
}

