/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConditionalCanBePushedInsideExpressionInspection
extends BaseInspection {
    public boolean ignoreSingleArgument = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            ConditionalCanBePushedInsideExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreSingleArgument", (String)InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ConditionalCanBePushedInsideExpressionInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new PushConditionalInsideFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalCanBePushedInsideExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ConditionalCanBePushedInsideExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PushConditionalInsideFix
    extends PsiUpdateModCommandQuickFix {
        private PushConditionalInsideFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.quickfix", new Object[0]);
            if (string == null) {
                PushConditionalInsideFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiConditionalExpression conditionalExpression;
            PsiExpression thenExpression;
            if (project == null) {
                PushConditionalInsideFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PushConditionalInsideFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PushConditionalInsideFix.$$$reportNull$$$0(3);
            }
            if ((thenExpression = (conditionalExpression = (PsiConditionalExpression)startElement).getThenExpression()) == null) {
                return;
            }
            EquivalenceChecker.Match match = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsMatch(thenExpression, conditionalExpression.getElseExpression());
            if (!match.isPartialMatch()) {
                return;
            }
            PsiElement leftDiff = match.getLeftDiff();
            PsiElement rightDiff = match.getRightDiff();
            String expression = "(" + conditionalExpression.getCondition().getText() + " ? " + leftDiff.getText() + " : " + rightDiff.getText() + ")";
            PsiExpression newConditionalExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(expression, (PsiElement)conditionalExpression);
            PsiElement replacedConditionalExpression = leftDiff.replace((PsiElement)newConditionalExpression);
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)((PsiExpression)replacedConditionalExpression), false);
            CommentTracker commentTracker = new CommentTracker();
            commentTracker.markUnchanged(conditionalExpression.getCondition());
            commentTracker.replaceAndRestoreComments((PsiElement)conditionalExpression, (PsiElement)thenExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/ConditionalCanBePushedInsideExpressionInspection$PushConditionalInsideFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/ConditionalCanBePushedInsideExpressionInspection$PushConditionalInsideFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ConditionalCanBePushedInsideExpressionVisitor
    extends BaseInspectionVisitor {
        private ConditionalCanBePushedInsideExpressionVisitor() {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                ConditionalCanBePushedInsideExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            PsiExpression thenExpression = expression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression.getElseExpression();
            EquivalenceChecker.Match match = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsMatch(thenExpression, elseExpression);
            if (match.isExactMismatch() || match.isExactMatch()) {
                return;
            }
            PsiElement leftDiff = match.getLeftDiff();
            if (!(leftDiff instanceof PsiExpression) || leftDiff.getParent() instanceof PsiStatement) {
                return;
            }
            PsiType type = ((PsiExpression)leftDiff).getType();
            if (type == null || PsiTypes.voidType().equals((Object)type)) {
                return;
            }
            if (ConditionalCanBePushedInsideExpressionInspection.this.ignoreSingleArgument && ConditionalCanBePushedInsideExpressionVisitor.isOnlyArgumentOfMethodCall(leftDiff, expression)) {
                if (!this.isOnTheFly()) {
                    return;
                }
                this.registerError((PsiElement)expression, ProblemHighlightType.INFORMATION, new Object[0]);
            } else {
                this.registerError((PsiElement)expression, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[0]);
            }
        }

        private static boolean isOnlyArgumentOfMethodCall(PsiElement element, PsiConditionalExpression conditional) {
            if (element == null) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            if (expressionList.getExpressionCount() != 1) {
                return false;
            }
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiElement greatGrandParent = ParenthesesUtils.getParentSkipParentheses(grandParent);
            return greatGrandParent == conditional;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/ConditionalCanBePushedInsideExpressionInspection$ConditionalCanBePushedInsideExpressionVisitor", "visitConditionalExpression"));
        }
    }
}

