/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfusingElseInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean reportWhenNoStatementFollow = true;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ConfusingElseBranch";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.else.problem.descriptor", new Object[0]);
        if (string == null) {
            ConfusingElseInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"reportWhenNoStatementFollow", (String)InspectionGadgetsBundle.message("confusing.else.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ConfusingElseInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingElseVisitor();
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new RemoveRedundantElseFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ConfusingElseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ConfusingElseVisitor
    extends BaseInspectionVisitor {
        private ConfusingElseVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiKeyword elseToken;
            if (statement == null) {
                ConfusingElseVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return;
            }
            if (!ConfusingElseInspection.this.reportWhenNoStatementFollow) {
                PsiStatement nextStatement = ConfusingElseVisitor.getNextStatement(statement);
                if (nextStatement == null) {
                    return;
                }
                if (!ControlFlowUtils.statementMayCompleteNormally(elseBranch)) {
                    return;
                }
            }
            if ((elseToken = statement.getElseElement()) == null) {
                return;
            }
            if (ConfusingElseVisitor.parentCompletesNormally((PsiElement)statement)) {
                return;
            }
            this.registerError((PsiElement)elseToken, new Object[0]);
        }

        private static boolean parentCompletesNormally(PsiElement element) {
            PsiElement parent = element.getParent();
            while (parent instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)parent;
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (elseBranch != element) {
                    return true;
                }
                PsiStatement thenBranch = ifStatement.getThenBranch();
                if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                    return true;
                }
                element = parent;
                parent = element.getParent();
            }
            return !(parent instanceof PsiCodeBlock);
        }

        @Nullable
        private static PsiStatement getNextStatement(PsiIfStatement statement) {
            PsiIfStatement parentIfStatement;
            PsiStatement elseBranch;
            PsiElement parent;
            while ((parent = statement.getParent()) instanceof PsiIfStatement && (elseBranch = (parentIfStatement = (PsiIfStatement)parent).getElseBranch()) == statement) {
                statement = parentIfStatement;
            }
            return (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/ConfusingElseInspection$ConfusingElseVisitor", "visitIfStatement"));
        }
    }

    private static class RemoveRedundantElseFix
    extends PsiUpdateModCommandQuickFix {
        private RemoveRedundantElseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.else.unwrap.quickfix", new Object[0]);
            if (string == null) {
                RemoveRedundantElseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement ifKeyword, @NotNull ModPsiUpdater updater) {
            PsiIfStatement ifStatement;
            if (project == null) {
                RemoveRedundantElseFix.$$$reportNull$$$0(1);
            }
            if (ifKeyword == null) {
                RemoveRedundantElseFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveRedundantElseFix.$$$reportNull$$$0(3);
            }
            if ((ifStatement = (PsiIfStatement)ifKeyword.getParent()) == null) {
                return;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            PsiIfStatement anchor = ifStatement;
            PsiElement parent = anchor.getParent();
            while (parent instanceof PsiIfStatement) {
                anchor = parent;
                parent = anchor.getParent();
            }
            if (elseBranch instanceof PsiBlockStatement) {
                PsiBlockStatement elseBlock = (PsiBlockStatement)elseBranch;
                PsiCodeBlock block = elseBlock.getCodeBlock();
                PsiElement[] children = block.getChildren();
                if (children.length > 2) {
                    parent.addRangeAfter(children[1], children[children.length - 2], (PsiElement)anchor);
                }
            } else {
                parent.addAfter((PsiElement)elseBranch, (PsiElement)anchor);
            }
            elseBranch.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/ConfusingElseInspection$RemoveRedundantElseFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifKeyword";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/ConfusingElseInspection$RemoveRedundantElseFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

