/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.MakeDefaultLastCaseFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultNotLastCaseInSwitchInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("default.not.last.case.in.switch.problem.descriptor", infos[1]);
        if (string == null) {
            DefaultNotLastCaseInSwitchInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiSwitchLabelStatementBase lbl = (PsiSwitchLabelStatementBase)infos[0];
        if (lbl instanceof PsiSwitchLabelStatement) {
            PsiElement prevStat;
            PsiElement lastDefaultStmt = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)lbl, PsiSwitchLabelStatementBase.class));
            if (!(lastDefaultStmt instanceof PsiBreakStatement) && !(lastDefaultStmt instanceof PsiYieldStatement)) {
                return null;
            }
            PsiSwitchLabelStatementBase prevLbl = (PsiSwitchLabelStatementBase)PsiTreeUtil.getPrevSiblingOfType((PsiElement)lbl, PsiSwitchLabelStatementBase.class);
            if (prevLbl != null && !((prevStat = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lbl)) instanceof PsiBreakStatement) && !(prevStat instanceof PsiYieldStatement)) {
                return null;
            }
        }
        return LocalQuickFix.from((ModCommandAction)new MakeDefaultLastCaseFix(lbl));
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DefaultNotLastCaseInSwitchVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DefaultNotLastCaseInSwitchInspection", "buildErrorString"));
    }

    private static class DefaultNotLastCaseInSwitchVisitor
    extends BaseInspectionVisitor {
        private DefaultNotLastCaseInSwitchVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                DefaultNotLastCaseInSwitchVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(statement);
            this.visitSwitchBlock((PsiSwitchBlock)statement);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                DefaultNotLastCaseInSwitchVisitor.$$$reportNull$$$0(1);
            }
            super.visitSwitchExpression(expression);
            this.visitSwitchBlock((PsiSwitchBlock)expression);
        }

        private void visitSwitchBlock(@NotNull PsiSwitchBlock statement) {
            PsiCodeBlock body;
            if (statement == null) {
                DefaultNotLastCaseInSwitchVisitor.$$$reportNull$$$0(2);
            }
            if ((body = statement.getBody()) == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            boolean labelSeen = false;
            for (int i = statements.length - 1; i >= 0; --i) {
                PsiStatement child = statements[i];
                if (!(child instanceof PsiSwitchLabelStatementBase)) continue;
                PsiSwitchLabelStatementBase label = (PsiSwitchLabelStatementBase)child;
                PsiElement defaultElement = JavaPsiSwitchUtil.findDefaultElement((PsiSwitchLabelStatementBase)label);
                if (defaultElement != null) {
                    if (labelSeen) {
                        this.registerError(defaultElement.getFirstChild(), label, JavaElementKind.fromElement((PsiElement)statement).subject());
                    }
                    return;
                }
                labelSeen = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/DefaultNotLastCaseInSwitchInspection$DefaultNotLastCaseInSwitchVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

