/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoopConditionNotUpdatedInsideLoopInspection
extends BaseInspection {
    public boolean ignorePossibleNonLocalChanges = true;
    public boolean ignoreIterators = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean entireCondition = (Boolean)infos[0];
        if (entireCondition) {
            String string = InspectionGadgetsBundle.message("loop.condition.not.updated.inside.loop.problem.descriptor", new Object[0]);
            if (string == null) {
                LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("loop.variable.not.updated.inside.loop.problem.descriptor", new Object[0]);
        if (string == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(2);
        }
        this.defaultWriteSettings(node, "ignorePossibleNonLocalChanges");
        this.writeBooleanOption(node, "ignorePossibleNonLocalChanges", true);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignorePossibleNonLocalChanges", (String)InspectionGadgetsBundle.message("loop.variable.not.updated.inside.loop.option.nonlocal", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new LoopConditionNotUpdatedInsideLoopVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private class LoopConditionNotUpdatedInsideLoopVisitor
    extends BaseInspectionVisitor {
        private LoopConditionNotUpdatedInsideLoopVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(statement);
            this.check((PsiConditionalLoopStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(1);
            }
            super.visitDoWhileStatement(statement);
            this.check((PsiConditionalLoopStatement)statement);
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(2);
            }
            super.visitForStatement(statement);
            this.check((PsiConditionalLoopStatement)statement);
        }

        private void check(@NotNull PsiConditionalLoopStatement statement) {
            if (statement == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(3);
            }
            PsiExpression condition = statement.getCondition();
            SmartList notUpdated = new SmartList();
            PsiStatement body = statement.getBody();
            if (body == null || condition == null || SideEffectChecker.mayHaveSideEffects(condition)) {
                return;
            }
            if (LoopConditionNotUpdatedInsideLoopInspection.this.ignorePossibleNonLocalChanges && !ExpressionUtils.isLocallyDefinedExpression(condition)) {
                PsiStatement update;
                if (SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)body)) {
                    return;
                }
                if (statement instanceof PsiForStatement && (update = ((PsiForStatement)statement).getUpdate()) != null && SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)update)) {
                    return;
                }
            }
            if (LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(condition, (PsiStatement)statement, (List<? super PsiExpression>)notUpdated)) {
                if (!ControlFlowUtils.statementMayCompleteNormally(body) && !ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                    return;
                }
                if (notUpdated.isEmpty()) {
                    if (!BoolUtils.isBooleanLiteral(condition)) {
                        this.registerError((PsiElement)condition, Boolean.TRUE);
                    }
                } else {
                    for (PsiExpression expression : notUpdated) {
                        this.registerError((PsiElement)expression, Boolean.FALSE);
                    }
                }
            }
        }

        private static boolean isConditionNotUpdated(@Nullable PsiExpression condition, @NotNull PsiStatement context, List<? super PsiExpression> notUpdated) {
            if (context == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(4);
            }
            if (condition == null) {
                return false;
            }
            if (PsiUtil.isConstantExpression((PsiExpression)condition) || ExpressionUtils.isNullLiteral(condition)) {
                return true;
            }
            if (condition instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)condition;
                PsiExpression operand = instanceOfExpression.getOperand();
                return LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(operand, context, notUpdated);
            }
            if (condition instanceof PsiParenthesizedExpression) {
                PsiExpression expression = ((PsiParenthesizedExpression)condition).getExpression();
                return LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(expression, context, notUpdated);
            }
            if (condition instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(operand, context, notUpdated)) continue;
                    return false;
                }
                return true;
            }
            if (condition instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)condition;
                PsiElement element = referenceExpression.resolve();
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    PsiType type = field.getType();
                    if (field.hasModifierProperty("final") && type.getArrayDimensions() == 0) {
                        if (field.hasModifierProperty("static")) {
                            return true;
                        }
                        PsiExpression qualifier = referenceExpression.getQualifierExpression();
                        if (qualifier == null) {
                            return true;
                        }
                        if (LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(qualifier, context, notUpdated)) {
                            return true;
                        }
                    }
                } else if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                    boolean arrayUpdated;
                    PsiVariable variable = (PsiVariable)element;
                    boolean isFinal = variable.hasModifierProperty("final");
                    PsiType type = variable.getType();
                    boolean bl = arrayUpdated = type instanceof PsiArrayType && VariableAccessUtils.arrayContentsAreAssigned(variable, (PsiElement)context);
                    if (!(!isFinal && VariableAccessUtils.variableIsAssigned(variable, (PsiElement)context) || arrayUpdated)) {
                        if (!isFinal) {
                            notUpdated.add((PsiExpression)referenceExpression);
                        }
                        return true;
                    }
                }
            } else if (condition instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
                if (!PsiUtil.isIncrementDecrementOperation((PsiElement)prefixExpression)) {
                    PsiExpression operand = prefixExpression.getOperand();
                    return LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(operand, context, notUpdated);
                }
            } else {
                if (condition instanceof PsiArrayAccessExpression) {
                    PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)condition;
                    PsiExpression indexExpression = accessExpression.getIndexExpression();
                    return LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(indexExpression, context, notUpdated) && LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(accessExpression.getArrayExpression(), context, notUpdated);
                }
                if (condition instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)condition;
                    PsiExpression thenExpression = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression = conditionalExpression.getElseExpression();
                    if (thenExpression == null || elseExpression == null) {
                        return false;
                    }
                    return LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(conditionalExpression.getCondition(), context, notUpdated) && LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(thenExpression, context, notUpdated) && LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(elseExpression, context, notUpdated);
                }
                if (condition instanceof PsiMethodCallExpression) {
                    PsiExpression qualifier = ((PsiMethodCallExpression)condition).getMethodExpression().getQualifierExpression();
                    if (!LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(qualifier, context, notUpdated)) {
                        return false;
                    }
                    for (PsiExpression arg : ((PsiMethodCallExpression)condition).getArgumentList().getExpressions()) {
                        if (LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(arg, context, notUpdated)) continue;
                        return false;
                    }
                    return true;
                }
                if (condition instanceof PsiTypeCastExpression) {
                    return LoopConditionNotUpdatedInsideLoopVisitor.isConditionNotUpdated(((PsiTypeCastExpression)condition).getOperand(), context, notUpdated);
                }
                if (condition instanceof PsiThisExpression || condition instanceof PsiClassObjectAccessExpression) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection$LoopConditionNotUpdatedInsideLoopVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isConditionNotUpdated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

