/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoopWithImplicitTerminationConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (Boolean.TRUE.equals(infos[0])) {
            String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.dowhile.problem.descriptor", new Object[0]);
            if (string == null) {
                LoopWithImplicitTerminationConditionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            LoopWithImplicitTerminationConditionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new LoopWithImplicitTerminationConditionFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new LoopWithImplicitTerminationConditionVisitor();
    }

    static boolean containsUnlabeledBreakStatement(@Nullable PsiStatement statement) {
        if (!(statement instanceof PsiBlockStatement)) {
            return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(statement);
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement firstStatement = ControlFlowUtils.getOnlyStatementInBlock(codeBlock);
        return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(firstStatement);
    }

    private static boolean isUnlabeledBreakStatement(@Nullable PsiStatement statement) {
        if (!(statement instanceof PsiBreakStatement)) {
            return false;
        }
        PsiBreakStatement breakStatement = (PsiBreakStatement)statement;
        PsiIdentifier identifier = breakStatement.getLabelIdentifier();
        return identifier == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection", "buildErrorString"));
    }

    private static class LoopWithImplicitTerminationConditionFix
    extends PsiUpdateModCommandQuickFix {
        private LoopWithImplicitTerminationConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.quickfix", new Object[0]);
            if (string == null) {
                LoopWithImplicitTerminationConditionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiStatement statement;
            boolean firstStatement;
            PsiConditionalLoopStatement parent;
            if (project == null) {
                LoopWithImplicitTerminationConditionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                LoopWithImplicitTerminationConditionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                LoopWithImplicitTerminationConditionFix.$$$reportNull$$$0(3);
            }
            if ((parent = (PsiConditionalLoopStatement)ObjectUtils.tryCast((Object)element.getParent(), PsiConditionalLoopStatement.class)) == null) {
                return;
            }
            PsiExpression loopCondition = parent.getCondition();
            if (loopCondition == null) {
                return;
            }
            PsiStatement body = parent.getBody();
            boolean bl = firstStatement = !(parent instanceof PsiDoWhileStatement);
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return;
                }
                statement = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                statement = body;
            }
            if (!(statement instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiExpression ifCondition = ifStatement.getCondition();
            if (ifCondition == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                CommentTracker commentTracker = new CommentTracker();
                String negatedExpressionText = BoolUtils.getNegatedExpressionText(ifCondition, commentTracker);
                PsiReplacementUtil.replaceExpression(loopCondition, negatedExpressionText, commentTracker);
                LoopWithImplicitTerminationConditionFix.replaceStatement((PsiStatement)ifStatement, elseBranch);
            } else if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch)) {
                loopCondition.replace((PsiElement)ifCondition);
                if (thenBranch == null) {
                    ifStatement.delete();
                } else {
                    LoopWithImplicitTerminationConditionFix.replaceStatement((PsiStatement)ifStatement, thenBranch);
                }
            }
        }

        private static void replaceStatement(@NotNull PsiStatement replacedStatement, @Nullable PsiStatement replacingStatement) {
            if (replacedStatement == null) {
                LoopWithImplicitTerminationConditionFix.$$$reportNull$$$0(4);
            }
            if (replacingStatement == null) {
                replacedStatement.delete();
                return;
            }
            if (!(replacingStatement instanceof PsiBlockStatement)) {
                replacedStatement.replace((PsiElement)replacingStatement);
                return;
            }
            PsiBlockStatement blockStatement = (PsiBlockStatement)replacingStatement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children = codeBlock.getChildren();
            if (children.length > 2) {
                PsiElement receiver = replacedStatement.getParent();
                for (int i = children.length - 2; i > 0; --i) {
                    PsiElement child = children[i];
                    if (child instanceof PsiWhiteSpace) continue;
                    receiver.addAfter(child, (PsiElement)replacedStatement);
                }
                replacedStatement.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection$LoopWithImplicitTerminationConditionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacedStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection$LoopWithImplicitTerminationConditionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceStatement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class LoopWithImplicitTerminationConditionVisitor
    extends BaseInspectionVisitor {
        private LoopWithImplicitTerminationConditionVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                LoopWithImplicitTerminationConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(statement);
            this.check((PsiConditionalLoopStatement)statement, false);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                LoopWithImplicitTerminationConditionVisitor.$$$reportNull$$$0(1);
            }
            super.visitDoWhileStatement(statement);
            this.check((PsiConditionalLoopStatement)statement, true);
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                LoopWithImplicitTerminationConditionVisitor.$$$reportNull$$$0(2);
            }
            super.visitForStatement(statement);
            this.check((PsiConditionalLoopStatement)statement, false);
        }

        private void check(PsiConditionalLoopStatement statement, boolean doWhile) {
            PsiExpression condition = statement.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition((PsiLoopStatement)statement, !doWhile)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, doWhile);
        }

        private static boolean isLoopWithImplicitTerminationCondition(PsiLoopStatement statement, boolean firstStatement) {
            PsiStatement bodyStatement;
            PsiStatement body = statement.getBody();
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return true;
                }
                bodyStatement = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                bodyStatement = body;
            }
            return !LoopWithImplicitTerminationConditionVisitor.isImplicitTerminationCondition(bodyStatement);
        }

        private static boolean isImplicitTerminationCondition(@Nullable PsiStatement statement) {
            if (!(statement instanceof PsiIfStatement)) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                return true;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            return LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection$LoopWithImplicitTerminationConditionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

