/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NegatedConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.conditional.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            NegatedConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new NegatedConditionalExpressionFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedConditionalExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedConditionalExpressionInspection", "buildErrorString"));
    }

    private static class NegatedConditionalExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private NegatedConditionalExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.conditional.expression.quickfix", new Object[0]);
            if (string == null) {
                NegatedConditionalExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiElement element;
            if (project == null) {
                NegatedConditionalExpressionFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                NegatedConditionalExpressionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                NegatedConditionalExpressionFix.$$$reportNull$$$0(3);
            }
            if (!((element = startElement.getParent()) instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpression.getOperand());
            if (!(operand instanceof PsiConditionalExpression)) {
                return;
            }
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)operand;
            StringBuilder newExpression = new StringBuilder();
            PsiExpression condition = conditionalExpression.getCondition();
            CommentTracker tracker = new CommentTracker();
            newExpression.append(tracker.text((PsiElement)condition)).append('?');
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            if (thenExpression != null) {
                newExpression.append(BoolUtils.getNegatedExpressionText(thenExpression, tracker));
            }
            newExpression.append(':');
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            if (elseExpression != null) {
                newExpression.append(BoolUtils.getNegatedExpressionText(elseExpression, tracker));
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, newExpression.toString(), tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/NegatedConditionalExpressionInspection$NegatedConditionalExpressionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/NegatedConditionalExpressionInspection$NegatedConditionalExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class NegatedConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private NegatedConditionalExpressionVisitor() {
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                NegatedConditionalExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitPrefixExpression(expression);
            if (!JavaTokenType.EXCL.equals(expression.getOperationTokenType())) {
                return;
            }
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
            if (!(operand instanceof PsiConditionalExpression)) {
                return;
            }
            this.registerError((PsiElement)expression.getOperationSign(), new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/NegatedConditionalExpressionInspection$NegatedConditionalExpressionVisitor", "visitPrefixExpression"));
        }
    }
}

