/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SwitchStatementWithConfusingDeclarationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "LocalVariableUsedAndDeclaredInDifferentSwitchBranches";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("switch.statement.with.confusing.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            SwitchStatementWithConfusingDeclarationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithConfusingDeclarationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection", "buildErrorString"));
    }

    private static class SwitchStatementWithConfusingDeclarationVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithConfusingDeclarationVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                SwitchStatementWithConfusingDeclarationVisitor.$$$reportNull$$$0(0);
            }
            this.checkSwitchBlock((PsiSwitchBlock)statement);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                SwitchStatementWithConfusingDeclarationVisitor.$$$reportNull$$$0(1);
            }
            this.checkSwitchBlock((PsiSwitchBlock)expression);
        }

        private void checkSwitchBlock(PsiSwitchBlock block) {
            PsiCodeBlock body = block.getBody();
            if (body == null) {
                return;
            }
            HashSet<PsiLocalVariable> variablesInPreviousBranches = new HashSet<PsiLocalVariable>(5);
            HashSet<PsiLocalVariable> variablesInCurrentBranch = new HashSet<PsiLocalVariable>(5);
            PsiStatement[] statements = body.getStatements();
            LocalVariableAccessVisitor visitor2 = new LocalVariableAccessVisitor(variablesInPreviousBranches);
            for (PsiStatement child : statements) {
                if (child instanceof PsiDeclarationStatement) {
                    PsiElement[] declaredElements;
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)child;
                    for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                        if (!(declaredElement instanceof PsiLocalVariable)) continue;
                        PsiLocalVariable localVariable = (PsiLocalVariable)declaredElement;
                        variablesInCurrentBranch.add(localVariable);
                    }
                } else if (child instanceof PsiSwitchLabelStatementBase) {
                    variablesInPreviousBranches.addAll(variablesInCurrentBranch);
                    variablesInCurrentBranch.clear();
                }
                child.accept((PsiElementVisitor)visitor2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection$SwitchStatementWithConfusingDeclarationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class LocalVariableAccessVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiLocalVariable> myVariablesInPreviousBranches;

            private LocalVariableAccessVisitor(Set<PsiLocalVariable> variablesInPreviousBranches) {
                this.myVariablesInPreviousBranches = variablesInPreviousBranches;
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    LocalVariableAccessVisitor.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(referenceExpression);
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                if (qualifier != null) {
                    return;
                }
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiLocalVariable)) {
                    return;
                }
                PsiLocalVariable accessedVariable = (PsiLocalVariable)element;
                if (this.myVariablesInPreviousBranches.contains(accessedVariable)) {
                    this.myVariablesInPreviousBranches.remove(accessedVariable);
                    SwitchStatementWithConfusingDeclarationVisitor.this.registerVariableError((PsiVariable)accessedVariable, new Object[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection$SwitchStatementWithConfusingDeclarationVisitor$LocalVariableAccessVisitor", "visitReferenceExpression"));
            }
        }
    }
}

