/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.SerialVersionUIDBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AddSerialVersionUIDFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("add.serialversionuidfield.quickfix", new Object[0]);
        if (string == null) {
            AddSerialVersionUIDFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement classIdentifier, @NotNull ModPsiUpdater updater) {
        long serialVersionUID;
        if (project == null) {
            AddSerialVersionUIDFix.$$$reportNull$$$0(1);
        }
        if (classIdentifier == null) {
            AddSerialVersionUIDFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            AddSerialVersionUIDFix.$$$reportNull$$$0(3);
        }
        PsiClass aClass = (PsiClass)classIdentifier.getParent();
        assert (aClass != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
        PsiField field = elementFactory.createFieldFromText(AddSerialVersionUIDFix.generateSerialVersionUIDFieldText(serialVersionUID = SerialVersionUIDBuilder.computeDefaultSUID(aClass)), (PsiElement)aClass);
        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.SERIAL_ANNOTATION, (PsiElement)field)) {
            AddSerialVersionUIDFix.annotateFieldWithSerial(field);
        }
        aClass.add((PsiElement)field);
    }

    @NonNls
    public static String generateSerialVersionUIDFieldText(long serialVersionUID) {
        return "private static final long serialVersionUID = " + serialVersionUID + "L;";
    }

    public static void annotateFieldWithSerial(@NotNull PsiField field) {
        PsiModifierList modifierList;
        if (field == null) {
            AddSerialVersionUIDFix.$$$reportNull$$$0(4);
        }
        if ((modifierList = field.getModifierList()) == null) {
            return;
        }
        PsiAnnotation annotation = AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent("java.io.Serial", PsiNameValuePair.EMPTY_ARRAY, (PsiAnnotationOwner)modifierList);
        if (annotation != null) {
            JavaCodeStyleManager.getInstance((Project)field.getProject()).shortenClassReferences((PsiElement)annotation);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/AddSerialVersionUIDFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classIdentifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/AddSerialVersionUIDFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotateFieldWithSerial";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

