/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ExtendsAnnotationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ClassExplicitlyAnnotation";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass containingClass = (PsiClass)infos[0];
        String string = containingClass.isInterface() ? InspectionGadgetsBundle.message("extends.annotation.interface.problem.descriptor", containingClass.getName()) : InspectionGadgetsBundle.message("extends.annotation.problem.descriptor", containingClass.getName());
        if (string == null) {
            ExtendsAnnotationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ANNOTATIONS);
        if (set == null) {
            ExtendsAnnotationInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/ExtendsAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ExtendsAnnotationVisitor
    extends BaseInspectionVisitor {
        private ExtendsAnnotationVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ExtendsAnnotationVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isAnnotationType() || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"javax.enterprise.util.AnnotationLiteral")) {
                return;
            }
            this.checkReferenceList(aClass.getExtendsList(), aClass);
            this.checkReferenceList(aClass.getImplementsList(), aClass);
        }

        private void checkReferenceList(PsiReferenceList referenceList, PsiClass containingClass) {
            PsiJavaCodeReferenceElement[] elements;
            if (referenceList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement element : elements = referenceList.getReferenceElements()) {
                PsiClass psiClass;
                PsiElement referent = element.resolve();
                if (!(referent instanceof PsiClass) || !(psiClass = (PsiClass)referent).isAnnotationType()) continue;
                this.registerError((PsiElement)element, containingClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/ExtendsAnnotationInspection$ExtendsAnnotationVisitor", "visitClass"));
        }
    }
}

