/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

public final class AbstractClassWithOnlyOneDirectInheritorInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.class.with.only.one.direct.inheritor.problem.descriptor", new Object[0]);
        if (string == null) {
            AbstractClassWithOnlyOneDirectInheritorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractClassWithOnlyOneDirectInheritorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/AbstractClassWithOnlyOneDirectInheritorInspection", "buildErrorString"));
    }

    private static class AbstractClassWithOnlyOneDirectInheritorVisitor
    extends BaseInspectionVisitor {
        private AbstractClassWithOnlyOneDirectInheritorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                AbstractClassWithOnlyOneDirectInheritorVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!InheritanceUtil.hasOneInheritor(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/j2me/AbstractClassWithOnlyOneDirectInheritorInspection$AbstractClassWithOnlyOneDirectInheritorVisitor", "visitClass"));
        }
    }
}

