/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class VarargParameterInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "VariableArgumentMethod";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("variable.argument.method.problem.descriptor", new Object[0]);
        if (string == null) {
            VarargParameterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        return new VarargParameterFix();
    }

    public static void modifyCall(PsiParameter varargParameter, int indexOfFirstVarargArgument, @NotNull PsiCall call) {
        PsiType componentType;
        MethodCandidateInfo info;
        JavaResolveResult resolveResult;
        if (call == null) {
            VarargParameterInspection.$$$reportNull$$$0(1);
        }
        if ((resolveResult = call.resolveMethodGenerics()) instanceof MethodCandidateInfo && (info = (MethodCandidateInfo)resolveResult).getApplicabilityLevel() != 2) {
            return;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        @NonNls StringBuilder builder = new StringBuilder("new ");
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiType type = substitutor.substitute(componentType = ((PsiEllipsisType)varargParameter.getType()).getComponentType());
        if (type instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType wildcardType = (PsiCapturedWildcardType)type;
            type = wildcardType.getLowerBound();
        }
        builder.append(JavaGenericsUtil.isReifiableType((PsiType)type) ? type.getCanonicalText() : TypeConversionUtil.erasure((PsiType)type).getCanonicalText());
        builder.append("[]{");
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length > indexOfFirstVarargArgument) {
            PsiElement start = VarargParameterInspection.skipToIncludeComments((PsiElement)arguments[indexOfFirstVarargArgument], false);
            PsiElement end = VarargParameterInspection.skipToIncludeComments((PsiElement)arguments[arguments.length - 1], true);
            PsiElement element = start;
            while (true) {
                builder.append(element.getText());
                if (element == end) break;
                element = element.getNextSibling();
            }
            argumentList.deleteChildRange(start, end);
        }
        builder.append('}');
        Project project = call.getProject();
        PsiExpression arrayExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(builder.toString(), (PsiElement)call);
        argumentList.add((PsiElement)arrayExpression);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)argumentList);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)argumentList);
    }

    private static PsiElement skipToIncludeComments(PsiElement element, boolean forward) {
        PsiElement sibling;
        PsiElement psiElement = sibling = forward ? element.getNextSibling() : element.getPrevSibling();
        if (sibling instanceof PsiComment) {
            return VarargParameterInspection.skipToIncludeComments(sibling, forward);
        }
        if (sibling instanceof PsiWhiteSpace) {
            PsiElement psiElement2 = sibling = forward ? sibling.getNextSibling() : sibling.getPrevSibling();
            if (sibling instanceof PsiComment) {
                return VarargParameterInspection.skipToIncludeComments(sibling, forward);
            }
        }
        return element;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new VarargParameterVisitor();
    }

    public static void convertVarargMethodToArray(@NotNull PsiMethod method) {
        if (method == null) {
            VarargParameterInspection.$$$reportNull$$$0(2);
        }
        VarargParameterFix.process(null, method);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/jdk/VarargParameterInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/jdk/VarargParameterInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "modifyCall";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertVarargMethodToArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class VarargParameterFix
    extends PsiUpdateModCommandQuickFix {
        private VarargParameterFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("variable.argument.method.quickfix", new Object[0]);
            if (string == null) {
                VarargParameterFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                VarargParameterFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                VarargParameterFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                VarargParameterFix.$$$reportNull$$$0(3);
            }
            VarargParameterFix.process(updater, (PsiMethod)element.getParent());
        }

        private static void process(@Nullable ModPsiUpdater updater, PsiMethod method) {
            int count;
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter lastParameter = parameterList.getParameter((count = parameterList.getParametersCount()) - 1);
            if (lastParameter == null || !lastParameter.isVarArgs()) {
                return;
            }
            List refElements = updater == null ? VarargParameterFix.getReferences(method) : ContainerUtil.map(VarargParameterFix.getReferences(method), e -> updater.getWritable(e));
            VarargParameterFix.performModification(method, count - 1, lastParameter, refElements);
        }

        @NotNull
        private static @Unmodifiable List<PsiElement> getReferences(@NotNull PsiMethod method) {
            if (method == null) {
                VarargParameterFix.$$$reportNull$$$0(4);
            }
            if (IntentionPreviewUtils.isIntentionPreviewActive()) {
                List list = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)method.getContainingFile()).filter(ref -> {
                    PsiReference docRef;
                    PsiReference patt0$temp;
                    PsiEnumConstant constant;
                    PsiJavaCodeReferenceElement element;
                    return ref instanceof PsiJavaCodeReferenceElement && (element = (PsiJavaCodeReferenceElement)ref).isReferenceTo((PsiElement)method) || ref instanceof PsiEnumConstant && method.isEquivalentTo((PsiElement)(constant = (PsiEnumConstant)ref).resolveMethod()) || ref instanceof PsiDocMethodOrFieldRef && (patt0$temp = ref.getReference()) instanceof PsiReference && (docRef = patt0$temp).isReferenceTo((PsiElement)method);
                })).toList();
                if (list == null) {
                    VarargParameterFix.$$$reportNull$$$0(5);
                }
                return list;
            }
            List list = ContainerUtil.map((Collection)ReferencesSearch.search((PsiElement)method).findAll(), PsiReference::getElement);
            if (list == null) {
                VarargParameterFix.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static void performModification(@NotNull PsiMethod method, int indexOfFirstVarargArgument, @NotNull PsiParameter lastParameter, @NotNull List<PsiElement> references) {
            if (method == null) {
                VarargParameterFix.$$$reportNull$$$0(7);
            }
            if (lastParameter == null) {
                VarargParameterFix.$$$reportNull$$$0(8);
            }
            if (references == null) {
                VarargParameterFix.$$$reportNull$$$0(9);
            }
            for (PsiElement reference : references) {
                if (reference instanceof PsiCall) {
                    PsiCall call = (PsiCall)reference;
                    VarargParameterInspection.modifyCall(lastParameter, indexOfFirstVarargArgument, call);
                } else {
                    PsiElement psiElement = reference.getParent();
                    if (psiElement instanceof PsiCall) {
                        PsiCall call = (PsiCall)psiElement;
                        VarargParameterInspection.modifyCall(lastParameter, indexOfFirstVarargArgument, call);
                    }
                }
                VarargParameterFix.modifyJavadoc(indexOfFirstVarargArgument, reference);
            }
            PsiEllipsisType type = (PsiEllipsisType)lastParameter.getType();
            PsiType arrayType = type.toArrayType();
            PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)lastParameter.getProject()).createTypeElement(arrayType);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"java.lang.SafeVarargs"});
            if (annotation != null) {
                annotation.delete();
            }
            PsiTypeElement typeElement = lastParameter.getTypeElement();
            assert (typeElement != null);
            PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)typeElement, (PsiElement)newTypeElement);
            JavaCodeStyleManager.getInstance((Project)method.getProject()).shortenClassReferences(result);
        }

        private static void modifyJavadoc(int indexOfFirstVarargArgument, @NotNull PsiElement reference) {
            if (reference == null) {
                VarargParameterFix.$$$reportNull$$$0(10);
            }
            if (!(reference instanceof PsiDocMethodOrFieldRef)) {
                return;
            }
            PsiDocMethodOrFieldRef ref = (PsiDocMethodOrFieldRef)reference;
            String[] signature = ref.getSignature();
            if (signature == null || signature.length - 1 != indexOfFirstVarargArgument) {
                return;
            }
            PsiElement name = ref.getNameElement();
            if (name == null) {
                return;
            }
            Object vararg = signature[indexOfFirstVarargArgument];
            if (!((String)vararg).endsWith("...")) {
                return;
            }
            vararg = ((String)vararg).substring(0, ((String)vararg).length() - 3) + "[]";
            StringBuilder text = new StringBuilder();
            text.append("/** {@link #").append(name.getText()).append("(");
            for (int i = 0; i < signature.length - 1; ++i) {
                text.append(signature[i]).append(",");
            }
            text.append((String)vararg).append(")} */");
            Project project = reference.getProject();
            PsiComment comment = JavaPsiFacade.getElementFactory((Project)project).createCommentFromText(text.toString(), reference);
            PsiElement inlineDocTag = (PsiElement)ContainerUtil.find((Object[])comment.getChildren(), c -> c instanceof PsiInlineDocTag);
            if (inlineDocTag == null) {
                return;
            }
            PsiElement newElement = (PsiElement)ContainerUtil.find((Object[])inlineDocTag.getChildren(), c -> c instanceof PsiDocMethodOrFieldRef);
            if (newElement == null) {
                return;
            }
            reference.replace(newElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 7, 8, 9, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/jdk/VarargParameterInspection$VarargParameterFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastParameter";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/jdk/VarargParameterInspection$VarargParameterFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferences";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "performModification";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "modifyJavadoc";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 7, 8, 9, 10 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class VarargParameterVisitor
    extends BaseInspectionVisitor {
        private VarargParameterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                VarargParameterVisitor.$$$reportNull$$$0(0);
            }
            if (method.isVarArgs()) {
                if (this.isVisibleHighlight((PsiElement)method)) {
                    this.registerMethodError(method, new Object[0]);
                } else {
                    this.registerErrorAtRange(method.getFirstChild(), (PsiElement)method.getParameterList(), new Object[0]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/jdk/VarargParameterInspection$VarargParameterVisitor", "visitMethod"));
        }
    }
}

