/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.CyclomaticComplexityVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public final class CyclomaticComplexityInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        return "OverlyComplexMethod";
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.complexity.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer complexity = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("cyclomatic.complexity.problem.descriptor", complexity);
        if (string == null) {
            CyclomaticComplexityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MethodComplexityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/CyclomaticComplexityInspection", "buildErrorString"));
    }

    private class MethodComplexityVisitor
    extends BaseInspectionVisitor {
        private MethodComplexityVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MethodComplexityVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            CyclomaticComplexityVisitor visitor2 = new CyclomaticComplexityVisitor();
            method.accept((PsiElementVisitor)visitor2);
            int complexity = visitor2.getComplexity();
            if (complexity <= CyclomaticComplexityInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, complexity);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/CyclomaticComplexityInspection$MethodComplexityVisitor", "visitMethod"));
        }
    }
}

