/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NCSSVisitor;
import org.jetbrains.annotations.NotNull;

public final class NonCommentSourceStatementsInspection
extends MethodMetricInspection {
    private static final int DEFAULT_LIMIT = 30;

    @NotNull
    public String getID() {
        return "OverlyLongMethod";
    }

    @Override
    protected int getDefaultLimit() {
        return 30;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("non.comment.source.statements.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer statementCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("non.comment.source.statements.problem.descriptor", statementCount);
        if (string == null) {
            NonCommentSourceStatementsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NonCommentSourceStatementsMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection", "buildErrorString"));
    }

    private class NonCommentSourceStatementsMethodVisitor
    extends BaseInspectionVisitor {
        private NonCommentSourceStatementsMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NonCommentSourceStatementsMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            NCSSVisitor visitor2 = new NCSSVisitor();
            method.accept((PsiElementVisitor)visitor2);
            int count = visitor2.getStatementCount();
            if (count <= NonCommentSourceStatementsInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, count);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection$NonCommentSourceStatementsMethodVisitor", "visitMethod"));
        }
    }
}

