/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstantMathCallInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NonNls
    static final Set<String> constantMathCall = Set.of("abs", "acos", "asin", "atan", "cbrt", "ceil", "cos", "cosh", "exp", "expm1", "floor", "log", "log10", "log1p", "rint", "round", "sin", "sinh", "sqrt", "tan", "tanh", "toDegrees", "toRadians");

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.math.call.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantMathCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new MakeStrictFix();
    }

    @Nullable
    @NonNls
    static String createValueString(@NonNls String name, double value) {
        if ("abs".equals(name)) {
            return Double.toString(Math.abs(value));
        }
        if ("floor".equals(name)) {
            return Double.toString(Math.floor(value));
        }
        if ("ceil".equals(name)) {
            return Double.toString(Math.ceil(value));
        }
        if ("toDegrees".equals(name)) {
            return Double.toString(Math.toDegrees(value));
        }
        if ("toRadians".equals(name)) {
            return Double.toString(Math.toRadians(value));
        }
        if ("sqrt".equals(name)) {
            return Double.toString(Math.sqrt(value));
        }
        if ("cbrt".equals(name)) {
            return Double.toString(Math.pow(value, 0.3333333333333333));
        }
        if ("round".equals(name)) {
            return Long.toString(Math.round(value));
        }
        if ("rint".equals(name)) {
            return Double.toString(Math.rint(value));
        }
        if ("log".equals(name)) {
            if (value == 1.0) {
                return "0.0";
            }
            return null;
        }
        if ("log10".equals(name)) {
            if (value == 1.0) {
                return "0.0";
            }
            return null;
        }
        if ("log1p".equals(name)) {
            if (value == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("exp".equals(name)) {
            if (value == 0.0) {
                return "1.0";
            }
            if (value == 1.0) {
                return "Math.E";
            }
            return null;
        }
        if ("expm1".equals(name)) {
            if (value == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("cos".equals(name) || "cosh".equals(name)) {
            if (value == 0.0) {
                return "1.0";
            }
            return null;
        }
        if ("acos".equals(name)) {
            if (value == 1.0) {
                return "0.0";
            }
            if (value == 0.0) {
                return "(Math.PI/2.0)";
            }
            return null;
        }
        if ("acosh".equals(name)) {
            if (value == 1.0) {
                return "0.0";
            }
            return null;
        }
        if ("sin".equals(name) || "sinh".equals(name)) {
            if (value == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("asin".equals(name)) {
            if (value == 0.0) {
                return "0.0";
            }
            if (value == 1.0) {
                return "(Math.PI/2.0)";
            }
            return null;
        }
        if ("asinh".equals(name)) {
            if (value == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("tan".equals(name) || "tanh".equals(name)) {
            if (value == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("atan".equals(name)) {
            if (value == 0.0) {
                return "0.0";
            }
            if (value == 1.0) {
                return "(Math.PI/4.0)";
            }
            return null;
        }
        if ("atanh".equals(name)) {
            if (value == 0.0) {
                return "0.0";
            }
            return null;
        }
        return null;
    }

    @Nullable
    @NonNls
    static String createValueString(@NonNls String name, long value) {
        if ("abs".equals(name)) {
            return Long.toString(Math.abs(value));
        }
        return null;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantMathCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConstantMathCallInspection", "buildErrorString"));
    }

    private static class MakeStrictFix
    extends PsiUpdateModCommandQuickFix {
        private MakeStrictFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                MakeStrictFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            String newExpression;
            if (project == null) {
                MakeStrictFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                MakeStrictFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MakeStrictFix.$$$reportNull$$$0(3);
            }
            PsiIdentifier nameIdentifier = (PsiIdentifier)startElement;
            PsiReferenceExpression reference = (PsiReferenceExpression)nameIdentifier.getParent();
            assert (reference != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)reference.getParent();
            assert (call != null);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            String methodName = reference.getReferenceName();
            PsiExpression argument = arguments[0];
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length != 1) {
                return;
            }
            PsiType type = parameters[0].getType();
            Object argumentValue = ConstantExpressionUtil.computeCastTo((PsiExpression)argument, (PsiType)type);
            if (argumentValue instanceof Float || argumentValue instanceof Double) {
                Number number = (Number)argumentValue;
                newExpression = ConstantMathCallInspection.createValueString(methodName, number.doubleValue());
            } else {
                Number number = (Number)argumentValue;
                newExpression = ConstantMathCallInspection.createValueString(methodName, number.longValue());
            }
            if (newExpression == null) {
                return;
            }
            if (PsiTypes.longType().equals((Object)type)) {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, newExpression + "L", new CommentTracker());
            } else {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, newExpression, new CommentTracker());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/ConstantMathCallInspection$MakeStrictFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/ConstantMathCallInspection$MakeStrictFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ConstantMathCallVisitor
    extends BaseInspectionVisitor {
        private ConstantMathCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ConstantMathCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!constantMathCall.contains(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression argument = arguments[0];
            Object argumentValue = ConstantExpressionUtil.computeCastTo((PsiExpression)argument, (PsiType)PsiTypes.doubleType());
            if (!(argumentValue instanceof Double)) {
                return;
            }
            double doubleValue = (Double)argumentValue;
            String valueString = ConstantMathCallInspection.createValueString(methodName, doubleValue);
            if (valueString == null) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass referencedClass = method.getContainingClass();
            if (referencedClass == null) {
                return;
            }
            String className = referencedClass.getQualifiedName();
            if (!"java.lang.Math".equals(className) && !"java.lang.StrictMath".equals(className)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/ConstantMathCallInspection$ConstantMathCallVisitor", "visitMethodCallExpression"));
        }
    }
}

