/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnaryPlusInspection
extends BaseInspection {
    public boolean onlyReportInsideBinaryExpression = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unary.plus.problem.descriptor", new Object[0]);
        if (string == null) {
            UnaryPlusInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyReportInsideBinaryExpression", (String)JavaAnalysisBundle.message((String)"inspection.unary.plus.unary.binary.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnaryPlusInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            UnaryPlusInspection.$$$reportNull$$$0(2);
        }
        this.writeBooleanOption(node, "onlyReportInsideBinaryExpression", true);
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        LocalQuickFix[] localQuickFixArray;
        boolean onTheFly = (Boolean)infos[0];
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)infos[1];
        LocalQuickFix fix = ConvertDoubleUnaryToPrefixOperationFix.createFix(prefixExpression);
        if (onTheFly && fix != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
            localQuickFixArray2[0] = new UnaryPlusFix();
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[1] = fix;
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[0] = new UnaryPlusFix();
        }
        if (localQuickFixArray == null) {
            UnaryPlusInspection.$$$reportNull$$$0(3);
        }
        return localQuickFixArray;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnaryPlusVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/numeric/UnaryPlusInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/numeric/UnaryPlusInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    static class ConvertDoubleUnaryToPrefixOperationFix
    extends PsiUpdateModCommandQuickFix {
        private final String myRefName;
        private final boolean myIncrement;

        private ConvertDoubleUnaryToPrefixOperationFix(@NotNull String refName, boolean increment) {
            if (refName == null) {
                ConvertDoubleUnaryToPrefixOperationFix.$$$reportNull$$$0(0);
            }
            this.myRefName = refName;
            this.myIncrement = increment;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("convert.double.unary.quickfix", this.myIncrement ? "++" : "--", this.myRefName);
            if (string == null) {
                ConvertDoubleUnaryToPrefixOperationFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("prefix.operation.quickfix.family.name", new Object[0]);
            if (string == null) {
                ConvertDoubleUnaryToPrefixOperationFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        static LocalQuickFix createFix(@NotNull PsiPrefixExpression prefixExpr) {
            PsiExpression operandExpr;
            PsiReferenceExpression operandRefExpr;
            boolean increment;
            if (prefixExpr == null) {
                ConvertDoubleUnaryToPrefixOperationFix.$$$reportNull$$$0(3);
            }
            PsiExpression operand = prefixExpr.getOperand();
            if (ConvertDoubleUnaryToPrefixOperationFix.isDesiredPrefixExpression(prefixExpr, true)) {
                increment = true;
            } else if (ConvertDoubleUnaryToPrefixOperationFix.isDesiredPrefixExpression(prefixExpr, false)) {
                increment = false;
            } else {
                return null;
            }
            if (operand instanceof PsiReferenceExpression) {
                PsiPrefixExpression parentPrefixExpr = (PsiPrefixExpression)ObjectUtils.tryCast((Object)prefixExpr.getParent(), PsiPrefixExpression.class);
                if (ConvertDoubleUnaryToPrefixOperationFix.isDesiredPrefixExpression(parentPrefixExpr, increment) && ConvertDoubleUnaryToPrefixOperationFix.containsOnlyWhitespaceBetweenOperatorAndOperand(prefixExpr) && ConvertDoubleUnaryToPrefixOperationFix.containsOnlyWhitespaceBetweenOperatorAndOperand(parentPrefixExpr)) {
                    return ConvertDoubleUnaryToPrefixOperationFix.createFix((PsiReferenceExpression)operand, increment);
                }
            } else if (operand instanceof PsiPrefixExpression && ConvertDoubleUnaryToPrefixOperationFix.isDesiredPrefixExpression((PsiPrefixExpression)operand, increment) && (operandRefExpr = (PsiReferenceExpression)ObjectUtils.tryCast((Object)(operandExpr = ((PsiPrefixExpression)operand).getOperand()), PsiReferenceExpression.class)) != null && ConvertDoubleUnaryToPrefixOperationFix.containsOnlyWhitespaceBetweenOperatorAndOperand(prefixExpr) && ConvertDoubleUnaryToPrefixOperationFix.containsOnlyWhitespaceBetweenOperatorAndOperand((PsiPrefixExpression)operand)) {
                return ConvertDoubleUnaryToPrefixOperationFix.createFix(operandRefExpr, increment);
            }
            return null;
        }

        @Nullable
        private static LocalQuickFix createFix(@NotNull PsiReferenceExpression refExpr, boolean increment) {
            String refName;
            if (refExpr == null) {
                ConvertDoubleUnaryToPrefixOperationFix.$$$reportNull$$$0(4);
            }
            if ((refName = refExpr.getReferenceName()) == null) {
                return null;
            }
            PsiPrefixExpression topPrefixExpr = (PsiPrefixExpression)ObjectUtils.tryCast((Object)refExpr.getParent().getParent(), PsiPrefixExpression.class);
            if (topPrefixExpr == null) {
                return null;
            }
            PsiType refExprType = refExpr.getType();
            if (TypeUtils.unaryNumericPromotion(refExprType) != refExprType && MethodCallUtils.isNecessaryForSurroundingMethodCall((PsiExpression)topPrefixExpr, (PsiExpression)refExpr)) {
                return null;
            }
            PsiVariable resolved = (PsiVariable)ObjectUtils.tryCast((Object)refExpr.resolve(), PsiVariable.class);
            if (resolved == null || resolved.hasModifierProperty("final")) {
                return null;
            }
            return new ConvertDoubleUnaryToPrefixOperationFix(refName, increment);
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiReferenceExpression refExpr;
            PsiExpression oldExpr;
            PsiPrefixExpression prefixExpr;
            if (project == null) {
                ConvertDoubleUnaryToPrefixOperationFix.$$$reportNull$$$0(5);
            }
            if (startElement == null) {
                ConvertDoubleUnaryToPrefixOperationFix.$$$reportNull$$$0(6);
            }
            if (updater == null) {
                ConvertDoubleUnaryToPrefixOperationFix.$$$reportNull$$$0(7);
            }
            if ((prefixExpr = (PsiPrefixExpression)ObjectUtils.tryCast((Object)startElement.getParent(), PsiPrefixExpression.class)) == null) {
                return;
            }
            PsiExpression operand = prefixExpr.getOperand();
            if (operand instanceof PsiReferenceExpression) {
                oldExpr = (PsiExpression)prefixExpr.getParent();
                refExpr = (PsiReferenceExpression)operand;
            } else if (operand instanceof PsiPrefixExpression) {
                oldExpr = prefixExpr;
                refExpr = (PsiReferenceExpression)((PsiPrefixExpression)operand).getOperand();
            } else {
                return;
            }
            if (refExpr == null || oldExpr == null) {
                return;
            }
            String refName = refExpr.getReferenceName();
            if (refName == null) {
                return;
            }
            String operatorText = this.myIncrement ? "++" : "--";
            PsiReplacementUtil.replaceExpression(oldExpr, operatorText + refName);
        }

        private static boolean containsOnlyWhitespaceBetweenOperatorAndOperand(@Nullable PsiPrefixExpression prefixExpression) {
            if (prefixExpression == null) {
                return false;
            }
            PsiJavaToken operator = prefixExpression.getOperationSign();
            PsiExpression operand = prefixExpression.getOperand();
            for (PsiElement nextSibling = operator.getNextSibling(); nextSibling != operand; nextSibling = nextSibling.getNextSibling()) {
                if (nextSibling instanceof PsiWhiteSpace) continue;
                return false;
            }
            return true;
        }

        static boolean isDesiredPrefixExpression(@Nullable PsiPrefixExpression prefixExpr, boolean increment) {
            return prefixExpr != null && (increment ? prefixExpr.getOperationTokenType().equals(JavaTokenType.PLUS) : prefixExpr.getOperationTokenType().equals(JavaTokenType.MINUS));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/UnaryPlusInspection$ConvertDoubleUnaryToPrefixOperationFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixExpr";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refExpr";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/UnaryPlusInspection$ConvertDoubleUnaryToPrefixOperationFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createFix";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class UnaryPlusFix
    extends PsiUpdateModCommandQuickFix {
        private UnaryPlusFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unary.plus.quickfix", new Object[0]);
            if (string == null) {
                UnaryPlusFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                UnaryPlusFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnaryPlusFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnaryPlusFix.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            PsiExpression operand = prefixExpression.getOperand();
            if (operand == null) {
                return;
            }
            prefixExpression.replace((PsiElement)operand);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/UnaryPlusInspection$UnaryPlusFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/UnaryPlusInspection$UnaryPlusFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class UnaryPlusVisitor
    extends BaseInspectionVisitor {
        private UnaryPlusVisitor() {
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression prefixExpression) {
            if (prefixExpression == null) {
                UnaryPlusVisitor.$$$reportNull$$$0(0);
            }
            super.visitPrefixExpression(prefixExpression);
            if (!ConvertDoubleUnaryToPrefixOperationFix.isDesiredPrefixExpression(prefixExpression, true)) {
                return;
            }
            PsiExpression operand = prefixExpression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType type = operand.getType();
            if (type == null) {
                return;
            }
            if (UnaryPlusInspection.this.onlyReportInsideBinaryExpression) {
                PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)prefixExpression);
                if (!(operand instanceof PsiParenthesizedExpression || operand instanceof PsiPrefixExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiAssignmentExpression || parent instanceof PsiVariable)) {
                    return;
                }
            } else if (TypeUtils.unaryNumericPromotion(type) != type && MethodCallUtils.isNecessaryForSurroundingMethodCall((PsiExpression)prefixExpression, operand)) {
                return;
            }
            this.registerError((PsiElement)prefixExpression.getOperationSign(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{this.isOnTheFly(), prefixExpression});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/siyeh/ig/numeric/UnaryPlusInspection$UnaryPlusVisitor", "visitPrefixExpression"));
        }
    }
}

