/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PackageGlobalInspection;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageInMultipleModulesInspection
extends PackageGlobalInspection {
    @Override
    public CommonProblemDescriptor @Nullable [] checkPackage(@NotNull RefPackage refPackage, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        Project project;
        PsiPackage aPackage;
        if (refPackage == null) {
            PackageInMultipleModulesInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            PackageInMultipleModulesInspection.$$$reportNull$$$0(1);
        }
        if (inspectionManager == null) {
            PackageInMultipleModulesInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            PackageInMultipleModulesInspection.$$$reportNull$$$0(3);
        }
        if ((aPackage = (PsiPackage)ReadAction.compute(() -> PackageInMultipleModulesInspection.lambda$checkPackage$0(project = inspectionManager.getProject(), refPackage))) == null) {
            return null;
        }
        PsiFile @NotNull [] files = (PsiFile[])ReadAction.compute(() -> aPackage.getFiles(GlobalSearchScope.projectScope((Project)project)));
        HashSet<@NotNull Module> modules = new HashSet<Module>();
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        for (PsiFile file : files) {
            Module module = index.getModuleForFile(file.getVirtualFile());
            if (module == null) continue;
            modules.add(module);
        }
        int moduleCount = modules.size();
        if (moduleCount <= 1) {
            return null;
        }
        ArrayList moduleList = new ArrayList(modules);
        String errorString = moduleCount == 2 ? InspectionGadgetsBundle.message("package.in.multiple.modules.problem.descriptor2", refPackage.getQualifiedName(), ((Module)moduleList.get(0)).getName(), ((Module)moduleList.get(1)).getName()) : (moduleCount == 3 ? InspectionGadgetsBundle.message("package.in.multiple.modules.problem.descriptor3", aPackage.getQualifiedName(), ((Module)moduleList.get(0)).getName(), ((Module)moduleList.get(1)).getName(), ((Module)moduleList.get(2)).getName()) : InspectionGadgetsBundle.message("package.in.multiple.modules.problem.descriptor.many", aPackage.getQualifiedName(), ((Module)moduleList.get(0)).getName(), ((Module)moduleList.get(1)).getName(), moduleCount - 2));
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    private static /* synthetic */ PsiPackage lambda$checkPackage$0(Project project, RefPackage refPackage) throws RuntimeException {
        return JavaPsiFacade.getInstance((Project)project).findPackage(refPackage.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refPackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "analysisScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "globalInspectionContext";
                break;
            }
        }
        objectArray[1] = "com/siyeh/ig/packaging/PackageInMultipleModulesInspection";
        objectArray[2] = "checkPackage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

