/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class InstantiatingObjectToGetClassObjectInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.problem.descriptor", new Object[0]);
        if (string == null) {
            InstantiatingObjectToGetClassObjectInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        if (ExpressionUtils.isVoidContext((PsiExpression)methodCallExpression)) {
            return null;
        }
        return new InstantiatingObjectToGetClassObjectFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new InstantiatingObjectToGetClassObjectVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection", "buildErrorString"));
    }

    private static class InstantiatingObjectToGetClassObjectFix
    extends PsiUpdateModCommandQuickFix {
        private InstantiatingObjectToGetClassObjectFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.replace.quickfix", new Object[0]);
            if (string == null) {
                InstantiatingObjectToGetClassObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression expression;
            PsiReferenceExpression methodExpression;
            PsiExpression qualifier;
            if (project == null) {
                InstantiatingObjectToGetClassObjectFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                InstantiatingObjectToGetClassObjectFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                InstantiatingObjectToGetClassObjectFix.$$$reportNull$$$0(3);
            }
            if ((qualifier = (methodExpression = (expression = (PsiMethodCallExpression)startElement).getMethodExpression()).getQualifierExpression()) == null) {
                return;
            }
            PsiType type = qualifier.getType();
            if (type == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, String.valueOf(InstantiatingObjectToGetClassObjectFix.getTypeText(type, new StringBuilder())) + ".class", new CommentTracker());
        }

        private static StringBuilder getTypeText(PsiType type, StringBuilder text) {
            if (type instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)type;
                text.append("[]");
                InstantiatingObjectToGetClassObjectFix.getTypeText(arrayType.getComponentType(), text);
            } else if (type instanceof PsiClassType) {
                PsiClass aClass = ((PsiClassType)type).resolve();
                if (aClass != null && PsiUtil.isLocalClass((PsiClass)aClass)) {
                    text.insert(0, aClass.getName());
                    for (aClass = aClass.getContainingClass(); aClass != null; aClass = aClass.getContainingClass()) {
                        text.insert(0, aClass.getName() + ".");
                    }
                } else {
                    String canonicalText = type.getCanonicalText();
                    String typeText = PsiNameHelper.getQualifiedClassName((String)canonicalText, (boolean)false);
                    text.insert(0, typeText);
                }
            } else {
                text.insert(0, type.getCanonicalText());
            }
            return text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection$InstantiatingObjectToGetClassObjectFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection$InstantiatingObjectToGetClassObjectFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class InstantiatingObjectToGetClassObjectVisitor
    extends BaseInspectionVisitor {
        private InstantiatingObjectToGetClassObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                InstantiatingObjectToGetClassObjectVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"getClass".equals(methodName) || !expression.getArgumentList().isEmpty()) {
                return;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            if (newExpression.getAnonymousClass() != null) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection$InstantiatingObjectToGetClassObjectVisitor", "visitMethodCallExpression"));
        }
    }
}

