/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RandomDoubleForRandomIntegerInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "UsingRandomNextDoubleForRandomInteger";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("random.double.for.random.integer.problem.descriptor", new Object[0]);
        if (string == null) {
            RandomDoubleForRandomIntegerInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new RandomDoubleForRandomIntegerFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new RandomDoubleForRandomIntegerVisitor();
    }

    @Nullable
    static PsiExpression getContainingExpression(PsiExpression expression) {
        PsiElement ancestor = expression.getParent();
        while (ancestor != null) {
            if (!(ancestor instanceof PsiExpression)) {
                return null;
            }
            if (!(ancestor instanceof PsiParenthesizedExpression)) {
                return (PsiExpression)ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection", "buildErrorString"));
    }

    private static class RandomDoubleForRandomIntegerFix
    extends PsiUpdateModCommandQuickFix {
        private RandomDoubleForRandomIntegerFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"nextInt()"});
            if (string == null) {
                RandomDoubleForRandomIntegerFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiExpression multiplierExpression;
            PsiIdentifier name;
            PsiReferenceExpression expression;
            if (project == null) {
                RandomDoubleForRandomIntegerFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                RandomDoubleForRandomIntegerFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RandomDoubleForRandomIntegerFix.$$$reportNull$$$0(3);
            }
            if ((expression = (PsiReferenceExpression)(name = (PsiIdentifier)startElement).getParent()) == null) {
                return;
            }
            PsiExpression call = (PsiExpression)expression.getParent();
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiBinaryExpression multiplication = (PsiBinaryExpression)RandomDoubleForRandomIntegerInspection.getContainingExpression(call);
            if (multiplication == null) {
                return;
            }
            PsiExpression cast = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)multiplication);
            if (cast == null) {
                return;
            }
            PsiExpression lhs = multiplication.getLOperand();
            PsiExpression strippedLhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)lhs);
            PsiExpression psiExpression = multiplierExpression = call.equals((Object)strippedLhs) ? multiplication.getROperand() : lhs;
            assert (multiplierExpression != null);
            CommentTracker commentTracker = new CommentTracker();
            String multiplierText = commentTracker.text((PsiElement)multiplierExpression);
            PsiReplacementUtil.replaceExpression(cast, commentTracker.text((PsiElement)qualifier) + ".nextInt((int) " + multiplierText + ")", commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection$RandomDoubleForRandomIntegerFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection$RandomDoubleForRandomIntegerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class RandomDoubleForRandomIntegerVisitor
    extends BaseInspectionVisitor {
        private RandomDoubleForRandomIntegerVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                RandomDoubleForRandomIntegerVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            @NonNls String nextDouble = "nextDouble";
            if (!"nextDouble".equals(methodName)) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.util.Random".equals(className)) {
                return;
            }
            PsiExpression possibleMultiplierExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)call);
            if (!RandomDoubleForRandomIntegerVisitor.isMultiplier(possibleMultiplierExpression)) {
                return;
            }
            PsiExpression possibleIntCastExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression(possibleMultiplierExpression);
            if (!RandomDoubleForRandomIntegerVisitor.isIntCast(possibleIntCastExpression)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static boolean isMultiplier(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.ASTERISK.equals(tokenType);
        }

        private static boolean isIntCast(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof PsiTypeCastExpression)) {
                return false;
            }
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)expression;
            PsiType type = castExpression.getType();
            return PsiTypes.intType().equals((Object)type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection$RandomDoubleForRandomIntegerVisitor", "visitMethodCallExpression"));
        }
    }
}

