/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceExpressionWithTextFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final String myReplacementText;
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private final String myName;

    public ReplaceExpressionWithTextFix(@NotNull @NonNls String replacementText, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String name) {
        if (replacementText == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(1);
        }
        this.myReplacementText = replacementText;
        this.myName = name;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
        PsiNewExpression newExpression;
        if (project == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(4);
        }
        if ((newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiNewExpression.class)) == null) {
            return;
        }
        PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)newExpression, this.myReplacementText);
        RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/ReplaceExpressionWithTextFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/ReplaceExpressionWithTextFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

