/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.JavaPsiBoxingUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessaryTemporaryOnConversionFromStringInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryTemporaryOnConversionFromStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    @NonNls
    static String calculateReplacementExpression(PsiMethodCallExpression expression, CommentTracker commentTracker, boolean fullyQualified) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiNewExpression qualifier = (PsiNewExpression)ObjectUtils.tryCast((Object)methodExpression.getQualifierExpression(), PsiNewExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiExpressionList argumentList = qualifier.getArgumentList();
        if (argumentList == null || argumentList.getExpressionCount() != 1) {
            return null;
        }
        PsiExpression arg = argumentList.getExpressions()[0];
        PsiType type = qualifier.getType();
        if (type == null) {
            return null;
        }
        String name = fullyQualified ? type.getCanonicalText() : type.getPresentableText();
        String conversionName = JavaPsiBoxingUtils.getParseMethod(type);
        if (TypeUtils.typeEquals("java.lang.Boolean", type) && !PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
            return name + ".valueOf(" + commentTracker.text((PsiElement)arg) + ").booleanValue()";
        }
        return name + "." + conversionName + "(" + commentTracker.text((PsiElement)arg) + ")";
    }

    @Override
    @Nullable
    public LocalQuickFix buildFix(Object ... infos) {
        String replacementExpression = UnnecessaryTemporaryOnConversionFromStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0], new CommentTracker(), false);
        if (replacementExpression == null) {
            return null;
        }
        String name = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{replacementExpression});
        return new UnnecessaryTemporaryObjectFix(name);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryTemporaryObjectVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection", "buildErrorString"));
    }

    private static final class UnnecessaryTemporaryObjectFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionName
        private final String m_name;

        private UnnecessaryTemporaryObjectFix(@IntentionName String name) {
            this.m_name = name;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement grandParent;
            if (project == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(4);
            }
            if (!((grandParent = element.getParent().getParent()) instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression expression = (PsiMethodCallExpression)grandParent;
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = UnnecessaryTemporaryOnConversionFromStringInspection.calculateReplacementExpression(expression, commentTracker, true);
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection$UnnecessaryTemporaryObjectFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection$UnnecessaryTemporaryObjectFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessaryTemporaryObjectVisitor
    extends BaseInspectionVisitor {
        @NonNls
        private static final Map<String, String> s_basicTypeMap = new HashMap<String, String>(7);

        private UnnecessaryTemporaryObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                UnnecessaryTemporaryObjectVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            Map<String, String> basicTypeMap = s_basicTypeMap;
            if (!basicTypeMap.containsValue(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiType argumentType = arguments[0].getType();
            if (!TypeUtils.isJavaLangString(argumentType)) {
                return;
            }
            PsiType type = qualifier.getType();
            if (type == null) {
                return;
            }
            String typeText = type.getCanonicalText();
            if (!basicTypeMap.containsKey(typeText)) {
                return;
            }
            String mappingMethod = basicTypeMap.get(typeText);
            if (!mappingMethod.equals(methodName)) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        static {
            s_basicTypeMap.put("java.lang.Boolean", "booleanValue");
            s_basicTypeMap.put("java.lang.Byte", "byteValue");
            s_basicTypeMap.put("java.lang.Double", "doubleValue");
            s_basicTypeMap.put("java.lang.Float", "floatValue");
            s_basicTypeMap.put("java.lang.Integer", "intValue");
            s_basicTypeMap.put("java.lang.Long", "longValue");
            s_basicTypeMap.put("java.lang.Short", "shortValue");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection$UnnecessaryTemporaryObjectVisitor", "visitMethodCallExpression"));
        }
    }
}

