/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SystemExitInspection
extends BaseInspection {
    public boolean ignoreInMainMethod = false;

    @NotNull
    public String getID() {
        return "CallToSystemExit";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String className = (String)infos[0];
        String string = InspectionGadgetsBundle.message("system.exit.call.problem.descriptor", className);
        if (string == null) {
            SystemExitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreInMainMethod", (String)InspectionGadgetsBundle.message("system.exit.call.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SystemExitInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SystemExitVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/portability/SystemExitInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SystemExitVisitor
    extends BaseInspectionVisitor {
        private SystemExitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiMethod containingMethod;
            if (expression == null) {
                SystemExitVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"exit".equals(methodName) && !"halt".equals(methodName)) {
                return;
            }
            if (SystemExitInspection.this.ignoreInMainMethod && (containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null && "main".equals(containingMethod.getName()) && PsiMethodUtil.isMainMethod((PsiMethod)containingMethod)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType parameterType = parameters[0].getType();
            if (!parameterType.equals(PsiTypes.intType())) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if ("java.lang.System".equals(className)) {
                this.registerMethodCallError(expression, "System");
            } else if ("java.lang.Runtime".equals(className)) {
                this.registerMethodCallError(expression, "Runtime");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/portability/SystemExitInspection$SystemExitVisitor", "visitMethodCallExpression"));
        }
    }
}

