/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtils {
    private static final Set<String> immutableTypes = new HashSet<String>(19);
    private static final Set<PsiType> primitiveNumericTypes = new HashSet<PsiType>(7);
    private static final Set<PsiType> integralTypes = new HashSet<PsiType>(5);

    private ClassUtils() {
    }

    @Nullable
    public static PsiClass findClass(@NonNls String fqClassName, PsiElement context) {
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(fqClassName, context.getResolveScope());
    }

    @Nullable
    public static PsiClass findObjectClass(PsiElement context) {
        return ClassUtils.findClass("java.lang.Object", context);
    }

    public static boolean isPrimitive(PsiType type) {
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type);
    }

    public static boolean isIntegral(PsiType type) {
        return integralTypes.contains(type);
    }

    @Contract(value="null -> false")
    public static boolean isImmutable(@Nullable PsiType type) {
        return ClassUtils.isImmutable(type, true);
    }

    @Contract(value="null,_ -> false")
    public static boolean isImmutable(@Nullable PsiType type, boolean checkDocComment) {
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type)) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (aClass == null) {
            return false;
        }
        return ClassUtils.isImmutableClass(aClass, checkDocComment);
    }

    public static boolean isImmutableClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassUtils.$$$reportNull$$$0(0);
        }
        return ClassUtils.isImmutableClass(aClass, false);
    }

    private static boolean isImmutableClass(@NotNull PsiClass aClass, boolean checkDocComment) {
        if (aClass == null) {
            ClassUtils.$$$reportNull$$$0(1);
        }
        if (aClass.isRecord()) {
            return true;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName != null && (immutableTypes.contains(qualifiedName) || qualifiedName.startsWith("com.google.common.collect.Immutable") && !qualifiedName.endsWith("Builder"))) {
            return true;
        }
        if (JCiPUtil.isImmutable(aClass, checkDocComment)) {
            return true;
        }
        return aClass.hasModifierProperty("final") && ContainerUtil.and((Object[])aClass.getAllFields(), field -> !field.hasModifierProperty("static") && field.hasModifierProperty("final") && (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)field.getType()) || immutableTypes.contains(field.getType().getCanonicalText())));
    }

    public static boolean inSamePackage(@Nullable PsiElement element1, @Nullable PsiElement element2) {
        if (element1 == null || element2 == null) {
            return false;
        }
        PsiFile containingFile1 = element1.getContainingFile();
        if (!(containingFile1 instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner containingJavaFile1 = (PsiClassOwner)containingFile1;
        String packageName1 = containingJavaFile1.getPackageName();
        PsiFile containingFile2 = element2.getContainingFile();
        if (!(containingFile2 instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner containingJavaFile2 = (PsiClassOwner)containingFile2;
        String packageName2 = containingJavaFile2.getPackageName();
        return packageName1.equals(packageName2);
    }

    @Contract(value="_, null -> false")
    public static boolean isInsideClassBody(@NotNull PsiElement element, @Nullable PsiClass outerClass) {
        if (element == null) {
            ClassUtils.$$$reportNull$$$0(2);
        }
        if (outerClass == null) {
            return false;
        }
        if (outerClass.isRecord() && PsiTreeUtil.isAncestor((PsiElement)outerClass.getRecordHeader(), (PsiElement)element, (boolean)true)) {
            return true;
        }
        PsiElement brace = outerClass.getLBrace();
        return brace != null && brace.getTextOffset() < element.getTextOffset();
    }

    public static boolean isFieldVisible(@NotNull PsiField field, PsiClass fromClass) {
        PsiClass fieldClass;
        if (field == null) {
            ClassUtils.$$$reportNull$$$0(3);
        }
        if ((fieldClass = field.getContainingClass()) == null) {
            return false;
        }
        if (fieldClass.equals((Object)fromClass)) {
            return true;
        }
        if (field.hasModifierProperty("private")) {
            return false;
        }
        if (field.hasModifierProperty("public") || field.hasModifierProperty("protected")) {
            return true;
        }
        return ClassUtils.inSamePackage((PsiElement)fieldClass, (PsiElement)fromClass);
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveNumericType(@Nullable PsiType type) {
        return primitiveNumericTypes.contains(type);
    }

    public static boolean isInnerClass(PsiClass aClass) {
        PsiClass parentClass = PsiUtil.getContainingClass((PsiElement)aClass);
        return parentClass != null;
    }

    public static PsiClass getOutermostContainingClass(PsiClass aClass) {
        PsiClass containingClass;
        PsiClass outerClass = aClass;
        while ((containingClass = PsiUtil.getContainingClass((PsiElement)outerClass)) != null) {
            outerClass = containingClass;
        }
        return outerClass;
    }

    @Nullable
    public static PsiClass getContainingStaticClass(PsiElement element) {
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false, (Class[])new Class[]{PsiFile.class});
        while (ClassUtils.isNonStaticClass(aClass)) {
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true, (Class[])new Class[]{PsiFile.class});
        }
        return aClass;
    }

    public static boolean isNonStaticClass(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        if (aClass.hasModifierProperty("static") || aClass.isInterface() || aClass.isEnum()) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiElement parent = aClass.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return false;
        }
        if (!(parent instanceof PsiClass)) {
            return true;
        }
        PsiClass parentClass = (PsiClass)parent;
        return !parentClass.isInterface();
    }

    @Nullable
    public static PsiClassInitializer getDoubleBraceInitializer(PsiAnonymousClass aClass) {
        PsiClassInitializer[] initializers = aClass.getInitializers();
        if (initializers.length != 1) {
            return null;
        }
        PsiClassInitializer initializer = initializers[0];
        if (initializer.hasModifierProperty("static")) {
            return null;
        }
        if (aClass.getFields().length != 0 || aClass.getMethods().length != 0 || aClass.getInnerClasses().length != 0) {
            return null;
        }
        if (aClass.getBaseClassReference().resolve() == null) {
            return null;
        }
        return initializer;
    }

    public static boolean isFinalClassWithDefaultEquals(@Nullable PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            return false;
        }
        if (!aClass.hasModifierProperty("final") && !ClassUtils.hasOnlyPrivateConstructors(aClass)) {
            return false;
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("equals", true)) {
            PsiClass containingClass;
            if (!MethodUtils.isEquals(method) || (containingClass = method.getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyPrivateConstructors(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.hasModifierProperty("private")) continue;
            return false;
        }
        return true;
    }

    public static boolean isSingleton(@Nullable PsiClass aClass) {
        if (aClass == null || aClass.isInterface() || aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (aClass.isEnum()) {
            if (!ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)aClass, 1, PsiEnumConstant.class)) {
                return false;
            }
            return ContainerUtil.exists((Object[])aClass.getMethods(), m -> !m.isConstructor() && !m.hasModifierProperty("private") && !m.hasModifierProperty("static"));
        }
        PsiMethod[] constructors = ClassUtils.getIfOnlyInvisibleConstructors(aClass);
        if (constructors.length != 1) {
            return false;
        }
        PsiField selfInstance = ClassUtils.getIfOneStaticSelfInstance(aClass);
        return selfInstance != null && ClassUtils.newOnlyAssignsToStaticSelfInstance(constructors[0], selfInstance);
    }

    private static PsiField getIfOneStaticSelfInstance(PsiClass aClass) {
        Stream<PsiField> fieldStream = Arrays.stream(aClass.getFields());
        StreamEx enclosingClassFields = ((StreamEx)StreamEx.iterate((Object)aClass.getContainingClass(), (Predicate)Predicates.nonNull(), c -> c.getContainingClass()).filter(Predicates.nonNull())).flatMap(c -> Stream.of(c.getFields()));
        fieldStream = Stream.concat(fieldStream, enclosingClassFields);
        List<PsiField> fields = (fieldStream = Stream.concat(fieldStream, Arrays.stream(aClass.getInnerClasses()).filter(innerClass -> innerClass.hasModifierProperty("static")).flatMap(innerClass -> Arrays.stream(innerClass.getFields())))).filter(field -> ClassUtils.resolveToSingletonField(aClass, field)).limit(2L).toList();
        return fields.size() == 1 ? fields.get(0) : null;
    }

    private static boolean resolveToSingletonField(PsiClass aClass, PsiField field) {
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)field.getType());
        PsiClass toCmp1 = aClass.isPhysical() ? aClass : aClass.getNavigationElement();
        PsiClass toCmp2 = targetClass == null || targetClass.isPhysical() ? targetClass : targetClass.getNavigationElement();
        return Objects.equals(toCmp1, toCmp2);
    }

    private static PsiMethod @NotNull [] getIfOnlyInvisibleConstructors(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                ClassUtils.$$$reportNull$$$0(4);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.hasModifierProperty("public")) {
                if (PsiMethod.EMPTY_ARRAY == null) {
                    ClassUtils.$$$reportNull$$$0(5);
                }
                return PsiMethod.EMPTY_ARRAY;
            }
            if (constructor.hasModifierProperty("private") || constructor.hasModifierProperty("protected")) continue;
            if (PsiMethod.EMPTY_ARRAY == null) {
                ClassUtils.$$$reportNull$$$0(6);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        if (constructors == null) {
            ClassUtils.$$$reportNull$$$0(7);
        }
        return constructors;
    }

    private static boolean newOnlyAssignsToStaticSelfInstance(PsiMethod method, PsiField field) {
        if (field instanceof LightElement) {
            return true;
        }
        Query search = MethodReferencesSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)false);
        NewOnlyAssignedToFieldProcessor processor = new NewOnlyAssignedToFieldProcessor(field);
        search.forEach((Processor)processor);
        return processor.isNewOnlyAssignedToField();
    }

    public static int getTypeOrdinal(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return 3;
        }
        if (aClass.isAnnotationType()) {
            return 4;
        }
        if (aClass.isInterface()) {
            return 2;
        }
        if (aClass.isEnum()) {
            return 5;
        }
        if (aClass.isRecord()) {
            return 6;
        }
        return 1;
    }

    static {
        integralTypes.add((PsiType)PsiTypes.longType());
        integralTypes.add((PsiType)PsiTypes.intType());
        integralTypes.add((PsiType)PsiTypes.shortType());
        integralTypes.add((PsiType)PsiTypes.charType());
        integralTypes.add((PsiType)PsiTypes.byteType());
        primitiveNumericTypes.add((PsiType)PsiTypes.byteType());
        primitiveNumericTypes.add((PsiType)PsiTypes.charType());
        primitiveNumericTypes.add((PsiType)PsiTypes.shortType());
        primitiveNumericTypes.add((PsiType)PsiTypes.intType());
        primitiveNumericTypes.add((PsiType)PsiTypes.longType());
        primitiveNumericTypes.add((PsiType)PsiTypes.floatType());
        primitiveNumericTypes.add((PsiType)PsiTypes.doubleType());
        immutableTypes.add("java.lang.Boolean");
        immutableTypes.add("java.lang.Character");
        immutableTypes.add("java.lang.Short");
        immutableTypes.add("java.lang.Integer");
        immutableTypes.add("java.lang.Long");
        immutableTypes.add("java.lang.Float");
        immutableTypes.add("java.lang.Double");
        immutableTypes.add("java.lang.Byte");
        immutableTypes.add("java.lang.String");
        immutableTypes.add("java.awt.Font");
        immutableTypes.add("java.awt.BasicStroke");
        immutableTypes.add("java.awt.Color");
        immutableTypes.add("java.awt.Cursor");
        immutableTypes.add("java.math.BigDecimal");
        immutableTypes.add("java.math.BigInteger");
        immutableTypes.add("java.math.MathContext");
        immutableTypes.add("java.nio.channels.FileLock");
        immutableTypes.add("java.nio.charset.Charset");
        immutableTypes.add("java.io.File");
        immutableTypes.add("java.net.Inet4Address");
        immutableTypes.add("java.net.Inet6Address");
        immutableTypes.add("java.net.InetSocketAddress");
        immutableTypes.add("java.net.URI");
        immutableTypes.add("java.net.URL");
        immutableTypes.add("java.util.Locale");
        immutableTypes.add("java.util.UUID");
        immutableTypes.add("java.util.regex.Pattern");
        immutableTypes.add("java.time.ZoneOffset");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ClassUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ClassUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIfOnlyInvisibleConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isImmutableClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInsideClassBody";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFieldVisible";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class NewOnlyAssignedToFieldProcessor
    implements Processor<PsiReference> {
        private boolean newOnlyAssignedToField = true;
        private final PsiField field;

        NewOnlyAssignedToFieldProcessor(PsiField field) {
            this.field = field;
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (this.field.equals((Object)grandParent)) {
                return true;
            }
            if (!(grandParent instanceof PsiAssignmentExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)grandParent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.field.equals((Object)target)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            return true;
        }

        public boolean isNewOnlyAssignedToField() {
            return this.newOnlyAssignedToField;
        }
    }
}

