/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeclarationSearchUtils {
    private DeclarationSearchUtils() {
    }

    public static boolean variableNameResolvesToTarget(@NotNull String variableName, @NotNull PsiVariable target, @NotNull PsiElement context) {
        if (variableName == null) {
            DeclarationSearchUtils.$$$reportNull$$$0(0);
        }
        if (target == null) {
            DeclarationSearchUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DeclarationSearchUtils.$$$reportNull$$$0(2);
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
        PsiVariable variable = resolveHelper.resolveAccessibleReferencedVariable(variableName, context);
        return target.equals((Object)variable);
    }

    @Nullable
    public static PsiExpression findDefinition(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiVariable variable) {
        PsiCodeBlock block;
        if (referenceExpression == null) {
            DeclarationSearchUtils.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            variable = (PsiVariable)target;
        }
        if ((block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) == null) {
            return null;
        }
        PsiElement[] defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)variable, (PsiElement)referenceExpression);
        if (defs.length != 1) {
            return null;
        }
        PsiElement def = defs[0];
        if (def instanceof PsiVariable) {
            PsiVariable target = (PsiVariable)def;
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)target.getInitializer());
        }
        if (def instanceof PsiReferenceExpression) {
            PsiAssignmentExpression assignmentExpression;
            PsiElement psiElement = def.getParent();
            if (!(psiElement instanceof PsiAssignmentExpression) || (assignmentExpression = (PsiAssignmentExpression)psiElement).getOperationTokenType() != JavaTokenType.EQ) {
                return null;
            }
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getRExpression());
        }
        return null;
    }

    public static boolean isTooExpensiveToSearch(PsiNamedElement element, boolean zeroResult) {
        String name = element.getName();
        if (name == null) {
            return true;
        }
        SearchScope useScope = element.getUseScope();
        if (!(useScope instanceof GlobalSearchScope)) {
            return false;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)useScope;
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)element.getProject());
        PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(name, globalSearchScope, null);
        return cost == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES ? zeroResult : cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    public static PsiField findFirstFieldInDeclaration(PsiField field) {
        PsiTypeElement typeElement = field.getTypeElement();
        if (typeElement == null) {
            return field;
        }
        return (PsiField)typeElement.getParent();
    }

    public static PsiField findNextFieldInDeclaration(PsiField field) {
        PsiField nextField = (PsiField)PsiTreeUtil.getNextSiblingOfType((PsiElement)field, PsiField.class);
        return nextField != null && field.getTypeElement() == nextField.getTypeElement() ? nextField : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/DeclarationSearchUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "variableNameResolvesToTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

