/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FieldAccessFixer(@NotNull String accessorName, @NotNull AccessorKind kind, boolean setter) {
    @NotNull
    private final String accessorName;
    @NotNull
    private final AccessorKind kind;

    public FieldAccessFixer(@NotNull String accessorName, @NotNull AccessorKind kind, boolean setter) {
        if (accessorName == null) {
            FieldAccessFixer.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            FieldAccessFixer.$$$reportNull$$$0(1);
        }
    }

    public void apply(@NotNull PsiReferenceExpression ref) {
        if (ref == null) {
            FieldAccessFixer.$$$reportNull$$$0(2);
        }
        String qualifier = null;
        PsiExpression qualifierExpression = ref.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifier = qualifierExpression.getText();
        }
        Project project = ref.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        String call = (String)(qualifier != null ? qualifier + "." : "") + this.accessorName;
        if (!this.setter) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(call + "()", null);
            callExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callExpression);
            ref.replace((PsiElement)callExpression);
        } else {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)ref, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression rExpression = assignmentExpression.getRExpression();
                String argList = rExpression != null ? rExpression.getText() : "";
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(call + "(" + argList + ")", null);
                callExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callExpression);
                parent.replace((PsiElement)callExpression);
            }
        }
    }

    @Nullable
    public static FieldAccessFixer create(@NotNull PsiReferenceExpression ref, @Nullable PsiElement target, @NotNull PsiElement place) {
        AccessorKind kind;
        PsiMethod accessor;
        boolean setter;
        PsiAssignmentExpression assignment;
        PsiClass accessObjectClass;
        if (ref == null) {
            FieldAccessFixer.$$$reportNull$$$0(3);
        }
        if (place == null) {
            FieldAccessFixer.$$$reportNull$$$0(4);
        }
        if (!(target instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)target;
        PsiElement qualifier = ref.getQualifier();
        if (qualifier instanceof PsiExpression) {
            PsiExpression expression = (PsiExpression)qualifier;
            v0 = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)expression).getElement();
        } else {
            v0 = accessObjectClass = null;
        }
        if (PsiUtil.isAccessible((PsiMember)field, (PsiElement)place, accessObjectClass)) {
            return null;
        }
        Predicate<PsiMethod> accessTest = m -> PsiUtil.isAccessible((PsiMember)m, (PsiElement)place, (PsiClass)accessObjectClass);
        if (PsiTypes.nullType().equals(field.getType())) {
            return null;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiElement element = PsiTreeUtil.skipParentsOfType((PsiElement)ref, (Class[])new Class[]{PsiParenthesizedExpression.class});
        PsiMethod prototype = null;
        if (element instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)element).getOperationTokenType() == JavaTokenType.EQ && PsiTreeUtil.isAncestor((PsiElement)assignment.getLExpression(), (PsiElement)ref, (boolean)false)) {
            setter = true;
            accessor = (PsiMethod)ContainerUtil.find((Object[])containingClass.getMethods(), method -> PropertyUtil.getFieldOfSetter(method) == field && accessTest.test((PsiMethod)method));
            if (accessor == null) {
                prototype = PropertyUtilBase.generateSetterPrototype((PsiField)field);
            }
        } else if (PsiUtil.isAccessedForReading((PsiExpression)ref)) {
            setter = false;
            accessor = Arrays.stream(containingClass.getMethods()).filter(method -> PropertyUtil.getFieldOfGetter(method) == field && accessTest.test((PsiMethod)method)).max(Comparator.comparing(m -> JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)m) != null)).orElse(null);
            if (accessor == null) {
                prototype = PropertyUtilBase.generateGetterPrototype((PsiField)field);
            }
        } else {
            return null;
        }
        if (prototype != null) {
            accessor = containingClass.findMethodBySignature(prototype, true);
            if (accessor == null || !accessTest.test(accessor)) {
                return null;
            }
            kind = AccessorKind.NAME_BASED;
        } else {
            kind = PsiUtil.canBeOverridden((PsiMethod)accessor) ? AccessorKind.OVERRIDABLE : AccessorKind.EXACT;
        }
        return new FieldAccessFixer(accessor.getName(), kind, setter);
    }

    @NotNull
    public String accessorName() {
        String string = this.accessorName;
        if (string == null) {
            FieldAccessFixer.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public AccessorKind kind() {
        AccessorKind accessorKind = this.kind;
        if (accessorKind == null) {
            FieldAccessFixer.$$$reportNull$$$0(6);
        }
        return accessorKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/FieldAccessFixer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/FieldAccessFixer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "accessorName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    public static enum AccessorKind {
        EXACT,
        OVERRIDABLE,
        NAME_BASED;

    }
}

