/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableAssignedFromVisitor
extends JavaRecursiveElementWalkingVisitor {
    private static final Logger LOG = Logger.getInstance(VariableAssignedFromVisitor.class);
    private boolean assignedFrom;
    @NotNull
    private final PsiVariable variable;

    VariableAssignedFromVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            VariableAssignedFromVisitor.$$$reportNull$$$0(0);
        }
        this.assignedFrom = false;
        this.variable = variable;
    }

    public void visitFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            VariableAssignedFromVisitor.$$$reportNull$$$0(1);
        }
        LOG.error("Unexpectedly visited PsiFile " + String.valueOf(psiFile) + " when tracing variable " + String.valueOf(this.variable));
        this.stopWalking();
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            VariableAssignedFromVisitor.$$$reportNull$$$0(2);
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression arg = assignment.getRExpression();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
            this.stopWalking();
        }
    }

    public void visitVariable(@NotNull PsiVariable var) {
        if (var == null) {
            VariableAssignedFromVisitor.$$$reportNull$$$0(3);
        }
        super.visitVariable(var);
        PsiExpression initializer = var.getInitializer();
        if (VariableAccessUtils.mayEvaluateToVariable(initializer, this.variable)) {
            this.assignedFrom = true;
            this.stopWalking();
        }
    }

    public boolean isAssignedFrom() {
        return this.assignedFrom;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/VariableAssignedFromVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

