/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiVariable;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariablePassedAsArgumentExcludedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private final Processor<? super PsiCall> myCallProcessor;
    private final boolean myBuilderPattern;
    private boolean passed;

    VariablePassedAsArgumentExcludedVisitor(@NotNull PsiVariable variable, boolean builderPattern, @NotNull Processor<? super PsiCall> callProcessor) {
        if (variable == null) {
            VariablePassedAsArgumentExcludedVisitor.$$$reportNull$$$0(0);
        }
        if (callProcessor == null) {
            VariablePassedAsArgumentExcludedVisitor.$$$reportNull$$$0(1);
        }
        this.variable = variable;
        this.myCallProcessor = callProcessor;
        this.myBuilderPattern = builderPattern;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            VariablePassedAsArgumentExcludedVisitor.$$$reportNull$$$0(2);
        }
        if (this.passed) {
            return;
        }
        super.visitElement(element);
    }

    public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
        if (callExpression == null) {
            VariablePassedAsArgumentExcludedVisitor.$$$reportNull$$$0(3);
        }
        if (this.passed) {
            return;
        }
        super.visitCallExpression(callExpression);
        this.visitCall((PsiCall)callExpression);
    }

    public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
        if (enumConstant == null) {
            VariablePassedAsArgumentExcludedVisitor.$$$reportNull$$$0(4);
        }
        if (this.passed) {
            return;
        }
        super.visitEnumConstant(enumConstant);
        this.visitCall((PsiCall)enumConstant);
    }

    private void visitCall(PsiCall call) {
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : argumentList.getExpressions()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable, this.myBuilderPattern) || this.myCallProcessor.process((Object)call)) continue;
            this.passed = true;
            break;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCallExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEnumConstant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

