/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariablePassedAsArgumentVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean passed;

    VariablePassedAsArgumentVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            VariablePassedAsArgumentVisitor.$$$reportNull$$$0(0);
        }
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            VariablePassedAsArgumentVisitor.$$$reportNull$$$0(1);
        }
        if (!this.passed) {
            super.visitElement(element);
        }
    }

    public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
        if (callExpression == null) {
            VariablePassedAsArgumentVisitor.$$$reportNull$$$0(2);
        }
        super.visitCallExpression(callExpression);
        if (this.passed) {
            return;
        }
        this.visitCall((PsiCall)callExpression);
    }

    public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
        if (enumConstant == null) {
            VariablePassedAsArgumentVisitor.$$$reportNull$$$0(3);
        }
        if (this.passed) {
            return;
        }
        super.visitEnumConstant(enumConstant);
        this.visitCall((PsiCall)enumConstant);
    }

    private void visitCall(PsiCall call) {
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : argumentList.getExpressions()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
            this.passed = true;
            break;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/VariablePassedAsArgumentVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCallExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEnumConstant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

