/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JNDIResourceInspection
extends ResourceInspection {
    @NotNull
    public String getID() {
        return "JNDIResourceOpenedButNotSafelyClosed";
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression) {
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if ("list".equals(methodName) || "listBindings".equals(methodName)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null) {
                    return false;
                }
                return TypeUtils.expressionHasTypeOrSubtype(qualifier, "javax.naming.Context");
            }
            if ("getAll".equals(methodName)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null) {
                    return false;
                }
                return TypeUtils.expressionHasTypeOrSubtype(qualifier, "javax.naming.directory.Attribute", "javax.naming.directory.Attributes") != null;
            }
            return false;
        }
        if (expression instanceof PsiNewExpression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression, "javax.naming.InitialContext");
        }
        return false;
    }
}

