/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceInspection
extends BaseInspection {
    public boolean insideTryAllowed;
    public boolean anyMethodMayClose = true;
    public boolean ignoreResourcesWithClose = true;
    private static final CallMatcher CLOSE = CallMatcher.instanceCall("java.lang.AutoCloseable", "close");

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            ResourceInspection.$$$reportNull$$$0(0);
        }
        this.defaultWriteSettings(node, "anyMethodMayClose", "ignoreResourcesWithClose");
        this.writeBooleanOption(node, "anyMethodMayClose", true);
        this.writeBooleanOption(node, "ignoreResourcesWithClose", true);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"insideTryAllowed", (String)InspectionGadgetsBundle.message("allow.resource.to.be.opened.inside.a.try.block", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"anyMethodMayClose", (String)InspectionGadgetsBundle.message("any.method.may.close.resource.argument", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ResourceInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("resource.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            ResourceInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ResourceVisitor();
    }

    @Contract(pure=true)
    protected boolean isSafelyClosedResource(@NotNull PsiExpression expression) {
        if (expression == null) {
            ResourceInspection.$$$reportNull$$$0(3);
        }
        return CLOSE.test(ExpressionUtils.getCallForQualifier(expression));
    }

    @Contract(pure=true)
    protected abstract boolean isResourceCreation(PsiExpression var1);

    @Contract(pure=true)
    protected boolean canTakeOwnership(@NotNull PsiExpression expression) {
        if (expression == null) {
            ResourceInspection.$$$reportNull$$$0(4);
        }
        return this.isResourceCreation(expression);
    }

    protected boolean isResourceFactoryClosed(PsiExpression expression) {
        return false;
    }

    @Nullable
    public static PsiVariable getVariable(@NotNull PsiExpression expression) {
        PsiYieldStatement yieldStatement;
        PsiSwitchExpression switchExpression;
        PsiCodeBlock codeBlock;
        PsiSwitchLabeledRuleStatement switchLabeledRuleStatement;
        PsiExpressionStatement expressionStatement;
        PsiElement psiElement;
        PsiElement parent;
        if (expression == null) {
            ResourceInspection.$$$reportNull$$$0(5);
        }
        if ((parent = ResourceInspection.getParent(expression)) instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement referent = referenceExpression.resolve();
            if (!(referent instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)referent;
            return variable;
        }
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            return variable;
        }
        if (parent instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
            return ResourceInspection.getVariable((PsiExpression)conditionalExpression);
        }
        if (parent instanceof PsiExpressionStatement && (psiElement = (expressionStatement = (PsiExpressionStatement)parent).getParent()) instanceof PsiSwitchLabeledRuleStatement && PsiTreeUtil.isAncestor((PsiElement)(switchLabeledRuleStatement = (PsiSwitchLabeledRuleStatement)psiElement).getBody(), (PsiElement)expressionStatement, (boolean)false) && (psiElement = switchLabeledRuleStatement.getParent()) instanceof PsiCodeBlock && (psiElement = (codeBlock = (PsiCodeBlock)psiElement).getParent()) instanceof PsiSwitchExpression) {
            PsiSwitchExpression switchExpression2 = (PsiSwitchExpression)psiElement;
            return ResourceInspection.getVariable((PsiExpression)switchExpression2);
        }
        if (parent instanceof PsiYieldStatement && (switchExpression = (yieldStatement = (PsiYieldStatement)parent).findEnclosingExpression()) != null) {
            return ResourceInspection.getVariable((PsiExpression)switchExpression);
        }
        return null;
    }

    private static PsiElement getParent(PsiExpression expression) {
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
        if (parent == null) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        PsiType type = expression.getType();
        if (type == null) {
            return null;
        }
        while (parent instanceof PsiReferenceExpression && grandParent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            if (!type.equals(methodCallExpression.getType())) {
                return null;
            }
            parent = ParenthesesUtils.getParentSkipParentheses(grandParent);
            if (parent == null) {
                return null;
            }
            grandParent = parent.getParent();
        }
        return parent;
    }

    private boolean isSafelyClosed(@Nullable PsiVariable variable, PsiElement context) {
        if (variable == null) {
            return false;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class);
        if (statement == null) {
            return false;
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        if (this.insideTryAllowed) {
            PsiTryStatement tryStatement;
            PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiStatement.class);
            while (parentStatement != null && !(parentStatement instanceof PsiTryStatement)) {
                parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, PsiStatement.class);
            }
            if (parentStatement != null && this.isResourceClosedInFinally(tryStatement = (PsiTryStatement)parentStatement, variable)) {
                return true;
            }
        }
        while (nextStatement != null && !ResourceInspection.isSignificant(nextStatement)) {
            nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
        }
        while (nextStatement == null) {
            if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiStatement.class, (boolean)true)) == null) {
                return false;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement) {
                statement = (PsiStatement)parent;
            }
            nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        }
        if (!(nextStatement instanceof PsiTryStatement)) {
            return this.isResourceClose(nextStatement, variable);
        }
        PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
        if (this.isResourceClosedInFinally(tryStatement, variable)) {
            return true;
        }
        return this.isResourceClose(nextStatement, variable);
    }

    private static boolean isSignificant(@NotNull PsiStatement statement) {
        if (statement == null) {
            ResourceInspection.$$$reportNull$$$0(6);
        }
        final Ref result = new Ref((Object)Boolean.TRUE);
        statement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitExpression(@NotNull PsiExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitExpression(expression);
                result.set((Object)Boolean.FALSE);
                this.stopWalking();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/resources/ResourceInspection$1", "visitExpression"));
            }
        });
        return (Boolean)result.get() == false;
    }

    boolean isResourceClosedInFinally(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable variable) {
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ResourceInspection.$$$reportNull$$$0(7);
        }
        if (variable == null) {
            ResourceInspection.$$$reportNull$$$0(8);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        CloseVisitor visitor2 = new CloseVisitor(variable);
        finallyBlock.accept((PsiElementVisitor)visitor2);
        return visitor2.containsClose();
    }

    private boolean isResourceClose(PsiStatement statement, PsiVariable variable) {
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            return this.isResourceClose(methodCallExpression, variable);
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (this.isResourceClose(ControlFlowUtils.getFirstStatementInBlock(tryBlock), variable)) {
                return true;
            }
        } else {
            if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiExpression condition = ifStatement.getCondition();
                if (!(condition instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (JavaTokenType.NE != tokenType) {
                    return false;
                }
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return false;
                }
                if (PsiTypes.nullType().equals(lhs.getType())) {
                    if (!(rhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)rhs;
                    PsiElement target = referenceExpression.resolve();
                    if (!variable.equals((Object)target)) {
                        return false;
                    }
                } else if (PsiTypes.nullType().equals(rhs.getType())) {
                    if (!(lhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)lhs;
                    PsiElement target = referenceExpression.resolve();
                    if (!variable.equals((Object)target)) {
                        return false;
                    }
                }
                PsiStatement thenBranch = ifStatement.getThenBranch();
                return this.isResourceClose(thenBranch, variable);
            }
            if (statement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                return this.isResourceClose(ControlFlowUtils.getFirstStatementInBlock(codeBlock), variable);
            }
        }
        return false;
    }

    protected boolean isResourceClose(PsiMethodCallExpression call, PsiVariable resource) {
        return MethodCallUtils.isMethodCallOnVariable(call, resource, "close");
    }

    @ApiStatus.Internal
    public boolean isResourceEscaping(@Nullable PsiVariable boundVariable, @NotNull PsiExpression resourceCreationExpression) {
        if (resourceCreationExpression == null) {
            ResourceInspection.$$$reportNull$$$0(9);
        }
        if (boundVariable instanceof PsiField) {
            return true;
        }
        if (ResourceInspection.isSystemErrOrOutUse(resourceCreationExpression)) {
            return true;
        }
        if (this.resourcePotentiallyCreatedFromOther(resourceCreationExpression)) {
            return true;
        }
        PsiElement parent = ExpressionUtils.getPassThroughParent(resourceCreationExpression);
        if (parent instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)parent;
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda);
            if (!PsiTypes.voidType().equals((Object)returnType)) {
                return true;
            }
        }
        if (parent instanceof PsiReturnStatement) {
            return true;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            if (PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getRExpression()) != resourceCreationExpression) {
                return true;
            }
            if (ResourceInspection.assignedToField(assignmentExpression)) {
                return true;
            }
        } else if (parent instanceof PsiExpressionList) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiAnonymousClass) {
                grandParent = grandParent.getParent();
            }
            if (grandParent instanceof PsiCallExpression) {
                return this.anyMethodMayClose || this.isResourceCreation((PsiExpression)grandParent);
            }
        }
        if (boundVariable == null) {
            return false;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)boundVariable, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (codeBlock == null) {
            return false;
        }
        EscapeVisitor visitor2 = new EscapeVisitor(boundVariable, resourceCreationExpression);
        codeBlock.accept((PsiElementVisitor)visitor2);
        return visitor2.isEscaped();
    }

    private boolean resourcePotentiallyCreatedFromOther(@NotNull PsiExpression resourceCreationExpression) {
        if (resourceCreationExpression == null) {
            ResourceInspection.$$$reportNull$$$0(10);
        }
        if (resourceCreationExpression instanceof PsiCallExpression) {
            PsiMethodCallExpression call;
            PsiExpression qualifier;
            PsiExpressionList argumentList = ((PsiCallExpression)resourceCreationExpression).getArgumentList();
            if (argumentList != null && ContainerUtil.or((Object[])argumentList.getExpressions(), this::canTakeOwnership)) {
                return true;
            }
            if (resourceCreationExpression instanceof PsiMethodCallExpression && (qualifier = (call = (PsiMethodCallExpression)resourceCreationExpression).getMethodExpression().getQualifierExpression()) != null && this.isResourceCreation(qualifier)) {
                return true;
            }
        }
        return false;
    }

    private static boolean assignedToField(PsiAssignmentExpression assignmentExpression) {
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression());
        if (!(lhs instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
        PsiElement target = referenceExpression.resolve();
        return target instanceof PsiField;
    }

    private static boolean isSystemErrOrOutUse(PsiExpression resourceCreationExpression) {
        PsiClass containingClass;
        PsiField field;
        String fieldName;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (!(resourceCreationExpression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)resourceCreationExpression;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        return qualifierExpression instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiField && ("out".equals(fieldName = (field = (PsiField)target).getName()) || "err".equals(fieldName)) && (containingClass = field.getContainingClass()) != null && "java.lang.System".equals(containingClass.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/resources/ResourceInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceCreationExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/resources/ResourceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSafelyClosedResource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canTakeOwnership";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSignificant";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isResourceClosedInFinally";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isResourceEscaping";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resourcePotentiallyCreatedFromOther";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private class ResourceVisitor
    extends BaseInspectionVisitor {
        private ResourceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ResourceVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!this.isNotSafelyClosedResource((PsiExpression)expression)) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                ResourceVisitor.$$$reportNull$$$0(1);
            }
            super.visitNewExpression(expression);
            if (!this.isNotSafelyClosedResource((PsiExpression)expression)) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        private boolean isNotSafelyClosedResource(PsiExpression expression) {
            if (!ResourceInspection.this.isResourceCreation(expression)) {
                return false;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(expression);
            return !(boundVariable instanceof PsiResourceVariable) && !ResourceInspection.this.isSafelyClosed(boundVariable, (PsiElement)expression) && !ResourceInspection.this.isResourceFactoryClosed(expression) && !ResourceInspection.this.isResourceEscaping(boundVariable, expression) && !ResourceInspection.this.isSafelyClosedResource(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/resources/ResourceInspection$ResourceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CloseVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsClose;
        private final PsiVariable resource;
        private final String resourceName;

        private CloseVisitor(PsiVariable resource) {
            this.resource = resource;
            this.resourceName = resource.getName();
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                CloseVisitor.$$$reportNull$$$0(0);
            }
            if (!this.containsClose) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                CloseVisitor.$$$reportNull$$$0(1);
            }
            if (this.containsClose) {
                return;
            }
            super.visitMethodCallExpression(call);
            if (!ResourceInspection.this.isResourceClose(call, this.resource)) {
                return;
            }
            this.containsClose = true;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                CloseVisitor.$$$reportNull$$$0(2);
            }
            super.visitReferenceExpression(referenceExpression);
            if (this.containsClose) {
                return;
            }
            String text = referenceExpression.getText();
            if (text == null || !text.equals(this.resourceName)) {
                return;
            }
            PsiElement parent = referenceExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiExpressionList argumentList = (PsiExpressionList)parent;
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null || !methodName.contains("close")) {
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (target == null || !target.equals((Object)this.resource)) {
                return;
            }
            this.containsClose = true;
        }

        private boolean containsClose() {
            return this.containsClose;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/resources/ResourceInspection$CloseVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class EscapeVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable boundVariable;
        @Nullable
        private final PsiLoopStatement loopStatement;
        private boolean escaped;

        EscapeVisitor(@NotNull PsiVariable boundVariable, PsiExpression creationExpression) {
            if (boundVariable == null) {
                EscapeVisitor.$$$reportNull$$$0(0);
            }
            if (creationExpression == null) {
                EscapeVisitor.$$$reportNull$$$0(1);
            }
            this.boundVariable = boundVariable;
            this.loopStatement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)creationExpression, PsiLoopStatement.class);
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                EscapeVisitor.$$$reportNull$$$0(2);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                EscapeVisitor.$$$reportNull$$$0(3);
            }
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                EscapeVisitor.$$$reportNull$$$0(4);
            }
            if (this.escaped) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                EscapeVisitor.$$$reportNull$$$0(5);
            }
            super.visitReturnStatement(statement);
            PsiExpression value = PsiUtil.deparenthesizeExpression((PsiExpression)statement.getReturnValue());
            if (!(value instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value;
            PsiElement target = referenceExpression.resolve();
            if (this.boundVariable.equals((Object)target)) {
                this.escaped = true;
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                EscapeVisitor.$$$reportNull$$$0(6);
            }
            super.visitAssignmentExpression(expression);
            PsiExpression rhs = PsiUtil.deparenthesizeExpression((PsiExpression)expression.getRExpression());
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)rhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.boundVariable.equals((Object)target)) {
                return;
            }
            PsiExpression lhs = PsiUtil.deparenthesizeExpression((PsiExpression)expression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression lReferenceExpression = (PsiReferenceExpression)lhs;
            PsiElement lTarget = lReferenceExpression.resolve();
            if (lTarget instanceof PsiField) {
                this.escaped = true;
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                EscapeVisitor.$$$reportNull$$$0(7);
            }
            super.visitReferenceExpression(expression);
            if (!ResourceInspection.this.ignoreResourcesWithClose) {
                return;
            }
            if (!ExpressionUtils.isReferenceTo((PsiExpression)expression, this.boundVariable)) {
                return;
            }
            PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression);
            if (call == null) {
                return;
            }
            String callName = call.getMethodExpression().getReferenceName();
            if ("close".equals(callName) && !this.canBeCloseOutsideLoop((PsiExpression)call)) {
                this.escaped = true;
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                EscapeVisitor.$$$reportNull$$$0(8);
            }
            super.visitMethodCallExpression(expression);
            if (!ResourceInspection.this.ignoreResourcesWithClose) {
                return;
            }
            String name = expression.getMethodExpression().getReferenceName();
            if (name == null) {
                return;
            }
            if ((StringUtil.containsIgnoreCase((String)name, (String)"close") || StringUtil.containsIgnoreCase((String)name, (String)"cleanup")) && !this.canBeCloseOutsideLoop((PsiExpression)expression)) {
                this.escaped = true;
            }
        }

        private boolean canBeCloseOutsideLoop(PsiExpression expression) {
            if (this.loopStatement == null) {
                return false;
            }
            return !PsiTreeUtil.isAncestor((PsiElement)this.loopStatement, (PsiElement)expression, (boolean)false);
        }

        public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
            PsiExpression[] expressions;
            if (callExpression == null) {
                EscapeVisitor.$$$reportNull$$$0(9);
            }
            super.visitCallExpression(callExpression);
            if (!ResourceInspection.this.anyMethodMayClose) {
                return;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            for (PsiExpression argument : expressions = argumentList.getExpressions()) {
                PsiExpression returnedValue;
                PsiExpression maybeReferenceExpression = PsiUtil.deparenthesizeExpression((PsiExpression)argument);
                if (!(maybeReferenceExpression instanceof PsiReferenceExpression) || !ExpressionUtils.isReferenceTo(maybeReferenceExpression, this.boundVariable)) continue;
                if (callExpression instanceof PsiMethodCallExpression && (returnedValue = JavaMethodContractUtil.findReturnedValue((PsiMethodCallExpression)callExpression)) != null && returnedValue == maybeReferenceExpression) {
                    return;
                }
                this.escaped = true;
                break;
            }
        }

        public void visitResourceVariable(@NotNull PsiResourceVariable variable) {
            if (variable == null) {
                EscapeVisitor.$$$reportNull$$$0(10);
            }
            super.visitResourceVariable(variable);
            if (ExpressionUtils.isReferenceTo(variable.getInitializer(), this.boundVariable)) {
                this.escaped = true;
            }
        }

        public void visitResourceExpression(@NotNull PsiResourceExpression expression) {
            if (expression == null) {
                EscapeVisitor.$$$reportNull$$$0(11);
            }
            super.visitResourceExpression(expression);
            if (ExpressionUtils.isReferenceTo(expression.getExpression(), this.boundVariable)) {
                this.escaped = true;
            }
        }

        public boolean isEscaped() {
            return this.escaped;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "boundVariable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "creationExpression";
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/resources/ResourceInspection$EscapeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitResourceVariable";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitResourceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

