/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.MissingSerialAnnotationInspection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SerialAnnotationUsedOnWrongMemberInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "serial";
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.SERIAL_ANNOTATION);
        if (set == null) {
            SerialAnnotationUsedOnWrongMemberInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("serial.annotation.used.on.wrong.member.problem.descriptor", infos);
        if (string == null) {
            SerialAnnotationUsedOnWrongMemberInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SerialAnnotationVisitor();
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new RemoveAnnotationQuickFix((PsiAnnotation)infos[0], null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/SerialAnnotationUsedOnWrongMemberInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SerialAnnotationVisitor
    extends BaseInspectionVisitor {
        private SerialAnnotationVisitor() {
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            boolean isWellAnnotatedElement;
            if (annotation == null) {
                SerialAnnotationVisitor.$$$reportNull$$$0(0);
            }
            super.visitAnnotation(annotation);
            if (!"java.io.Serial".equals(annotation.getQualifiedName())) {
                return;
            }
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class);
            if (psiClass == null) {
                return;
            }
            if (!SerializationUtils.isSerializable(psiClass)) {
                this.registerError((PsiElement)annotation, annotation);
                return;
            }
            PsiAnnotationOwner annotationOwner = annotation.getOwner();
            if (!(annotationOwner instanceof PsiModifierList)) {
                return;
            }
            PsiElement annotationOwnerParent = ((PsiModifierList)annotationOwner).getParent();
            PsiField psiField = null;
            PsiMethod psiMethod = null;
            if (annotationOwnerParent instanceof PsiField) {
                psiField = (PsiField)annotationOwnerParent;
            } else if (annotationOwnerParent instanceof PsiMethod) {
                psiMethod = (PsiMethod)annotationOwnerParent;
            } else {
                return;
            }
            if (SerializationUtils.isExternalizable(psiClass)) {
                isWellAnnotatedElement = psiField == null ? MissingSerialAnnotationInspection.isSerialMethodInExternalizable(psiMethod) : SerializationUtils.isSerialVersionUid(psiField);
            } else {
                boolean bl = psiField == null ? MissingSerialAnnotationInspection.isSerialMethodInSerializable(psiMethod) : (isWellAnnotatedElement = SerializationUtils.isSerialVersionUid(psiField) || SerializationUtils.isSerialPersistentFields(psiField));
            }
            if (!isWellAnnotatedElement) {
                this.registerError((PsiElement)annotation, annotation);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/siyeh/ig/serialization/SerialAnnotationUsedOnWrongMemberInspection$SerialAnnotationVisitor", "visitAnnotation"));
        }
    }
}

