/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.MissingSerialAnnotationInspection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SerializableRecordContainsIgnoredMembersInspection
extends BaseInspection {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.RECORDS);
        if (set == null) {
            SerializableRecordContainsIgnoredMembersInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... infos) {
        Object member = infos[0];
        if (member instanceof PsiField) {
            String string = InspectionGadgetsBundle.message("serializable.record.contains.ignored.field.problem.descriptor", member);
            if (string == null) {
                SerializableRecordContainsIgnoredMembersInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("serializable.record.contains.ignored.method.problem.descriptor", member);
        if (string == null) {
            SerializableRecordContainsIgnoredMembersInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableRecordContainsIgnoredMembersVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/SerializableRecordContainsIgnoredMembersInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SerializableRecordContainsIgnoredMembersVisitor
    extends BaseInspectionVisitor {
        private SerializableRecordContainsIgnoredMembersVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                SerializableRecordContainsIgnoredMembersVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            PsiClass psiClass = MissingSerialAnnotationInspection.getSerializablePsiClass((PsiElement)field);
            if (psiClass == null || !psiClass.isRecord()) {
                return;
            }
            if (SerializationUtils.isExternalizable(psiClass)) {
                return;
            }
            if (SerializationUtils.isSerialPersistentFields(field)) {
                this.registerFieldError(field, field);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                SerializableRecordContainsIgnoredMembersVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethod(method);
            PsiClass psiClass = MissingSerialAnnotationInspection.getSerializablePsiClass((PsiElement)method);
            if (psiClass == null || !psiClass.isRecord()) {
                return;
            }
            if (SerializationUtils.isExternalizable(psiClass) && method.hasModifierProperty("public") && (SerializationUtils.isReadExternal(method) || SerializationUtils.isWriteExternal(method))) {
                this.registerMethodError(method, method);
            } else if (SerializationUtils.isSerializable(psiClass) && method.hasModifierProperty("private") && (SerializationUtils.isWriteObject(method) || SerializationUtils.isReadObject(method) || SerializationUtils.isReadObjectNoData(method))) {
                this.registerMethodError(method, method);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/serialization/SerializableRecordContainsIgnoredMembersInspection$SerializableRecordContainsIgnoredMembersVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

