/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.NormalizeDeclarationFix;
import org.jetbrains.annotations.NotNull;

public class CStyleArrayDeclarationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final TokenSet BRACKET_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LBRACKET, JavaTokenType.RBRACKET});
    public boolean ignoreVariables = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object info = infos[0];
        if (info instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)info;
            String string = InspectionGadgetsBundle.message("cstyle.array.method.declaration.problem.descriptor", method.getName());
            if (string == null) {
                CStyleArrayDeclarationInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        int choice = info instanceof PsiField ? 1 : (info instanceof PsiParameter ? 2 : (info instanceof PsiRecordComponent ? 3 : 4));
        String string = InspectionGadgetsBundle.message("cstyle.array.variable.declaration.problem.descriptor", choice, ((PsiVariable)info).getName());
        if (string == null) {
            CStyleArrayDeclarationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreVariables", (String)JavaAnalysisBundle.message((String)"inspection.c.style.array.declarations.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            CStyleArrayDeclarationInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new NormalizeDeclarationFix(true);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CStyleArrayDeclarationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/CStyleArrayDeclarationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CStyleArrayDeclarationVisitor
    extends BaseInspectionVisitor {
        private CStyleArrayDeclarationVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            PsiParameter parameter;
            if (variable == null) {
                CStyleArrayDeclarationVisitor.$$$reportNull$$$0(0);
            }
            super.visitVariable(variable);
            if (CStyleArrayDeclarationInspection.this.ignoreVariables || variable instanceof PsiRecordComponent) {
                return;
            }
            if (variable.isUnnamed()) {
                return;
            }
            if (variable instanceof PsiParameter && (parameter = (PsiParameter)variable).isVarArgs()) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null || typeElement.isInferredType()) {
                return;
            }
            PsiType declaredType = variable.getType();
            if (declaredType.getArrayDimensions() == 0) {
                return;
            }
            PsiType elementType = typeElement.getType();
            if (elementType.equals(declaredType)) {
                return;
            }
            if (this.isVisibleHighlight((PsiElement)variable)) {
                this.highlightBrackets((PsiElement)variable, (PsiElement)variable.getNameIdentifier());
            } else {
                this.registerError((PsiElement)variable, variable);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                CStyleArrayDeclarationVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethod(method);
            PsiType returnType = method.getReturnType();
            if (returnType == null || returnType.getArrayDimensions() == 0) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType type = typeElement.getType();
            if (type.equals(returnType)) {
                return;
            }
            if (InspectionProjectProfileManager.isInformationLevel((String)CStyleArrayDeclarationInspection.this.getShortName(), (PsiElement)method)) {
                this.registerError((PsiElement)typeElement, method);
                this.registerMethodError(method, method);
            }
            this.highlightBrackets((PsiElement)method, (PsiElement)method.getParameterList());
        }

        private void highlightBrackets(@NotNull PsiElement problemElement, PsiElement anchor) {
            if (problemElement == null) {
                CStyleArrayDeclarationVisitor.$$$reportNull$$$0(2);
            }
            PsiElement start = null;
            PsiElement end = null;
            while (anchor != null) {
                if (anchor instanceof PsiAnnotation) {
                    if (start == null) {
                        start = anchor;
                    }
                } else if (PsiUtil.isJavaToken((PsiElement)anchor, (TokenSet)BRACKET_TOKENS)) {
                    if (start == null) {
                        start = anchor;
                    }
                    end = anchor;
                }
                anchor = anchor.getNextSibling();
            }
            if (start != null && end != null) {
                this.registerErrorAtRange(start, end, problemElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemElement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/CStyleArrayDeclarationInspection$CStyleArrayDeclarationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightBrackets";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

