/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.style.ConditionalModel;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConditionalExpressionGenerator {
    @NotNull
    private final String myTokenType;
    @NotNull
    private final @NotNull Function<@NotNull CommentTracker, @NotNull String> myGenerator;
    @Nullable
    private final PsiExpression myReplacement;

    private ConditionalExpressionGenerator(@NotNull String type, @NotNull @NotNull Function<@NotNull CommentTracker, @NotNull String> generator) {
        if (type == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(0);
        }
        if (generator == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(1);
        }
        this.myTokenType = type;
        this.myGenerator = generator;
        this.myReplacement = null;
    }

    private ConditionalExpressionGenerator(@NotNull String type, @NotNull PsiExpression replacement) {
        if (type == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(2);
        }
        if (replacement == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(3);
        }
        this.myTokenType = type;
        this.myGenerator = ct -> ct.text((PsiElement)replacement);
        this.myReplacement = replacement;
    }

    @Nullable
    public PsiExpression getReplacement() {
        return this.myReplacement;
    }

    @NotNull
    public String getTokenType() {
        String string = this.myTokenType;
        if (string == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String generate(CommentTracker ct) {
        String string = this.myGenerator.apply(ct);
        if (string == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static ConditionalExpressionGenerator from(ConditionalModel model) {
        PsiExpression redundantComparisonReplacement;
        PsiExpression condition = model.getCondition();
        PsiExpression thenExpression = model.getThenExpression();
        PsiExpression elseExpression = model.getElseExpression();
        if (PsiTypes.booleanType().equals((Object)model.getType()) || model.getType().equalsToText("java.lang.Boolean")) {
            Boolean elseValue;
            PsiLiteralExpression thenLiteral = ExpressionUtils.getLiteral(thenExpression);
            PsiLiteralExpression elseLiteral = ExpressionUtils.getLiteral(elseExpression);
            Boolean thenValue = thenLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)thenLiteral.getValue(), Boolean.class);
            Boolean bl = elseValue = elseLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)elseLiteral.getValue(), Boolean.class);
            if (thenValue != null && elseValue != null) {
                if (thenValue.equals(elseValue)) {
                    return null;
                }
                if (thenValue.booleanValue()) {
                    return new ConditionalExpressionGenerator("", condition);
                }
                return new ConditionalExpressionGenerator("", ct -> BoolUtils.getNegatedExpressionText(condition, ct));
            }
            if ((thenValue != null || elseValue != null) && PsiTypes.booleanType().equals((Object)model.getType())) {
                return ConditionalExpressionGenerator.getAndOrGenerator(condition, thenExpression, elseExpression, thenValue, elseValue);
            }
            if (BoolUtils.areExpressionsOpposite(thenExpression, elseExpression)) {
                return ConditionalExpressionGenerator.getEqualityGenerator(model.getCondition(), thenExpression);
            }
        }
        if ((redundantComparisonReplacement = ConditionalExpressionGenerator.getRedundantComparisonReplacement(model)) != null) {
            return new ConditionalExpressionGenerator("", redundantComparisonReplacement);
        }
        ConditionalExpressionGenerator simplifiableBooleanTernaryGenerator = ConditionalExpressionGenerator.getSimplifiableBooleanTernaryGenerator(model);
        if (simplifiableBooleanTernaryGenerator != null) {
            return simplifiableBooleanTernaryGenerator;
        }
        return new ConditionalExpressionGenerator("?:", ct -> ConditionalExpressionGenerator.generateTernary(ct, condition, thenExpression, elseExpression, model.getType()));
    }

    private static ConditionalExpressionGenerator getAndOrGenerator(PsiExpression condition, PsiExpression thenExpression, PsiExpression elseExpression, Boolean thenValue, Boolean elseValue) {
        if (thenValue != null) {
            if (thenValue.booleanValue()) {
                return new ConditionalExpressionGenerator("||", ct -> ConditionalExpressionGenerator.joinConditions(condition, elseExpression, false, ct));
            }
            return new ConditionalExpressionGenerator("&&", ct -> BoolUtils.getNegatedExpressionText(condition, 13, ct) + " && " + ct.text(elseExpression, 13));
        }
        if (!elseValue.booleanValue()) {
            return new ConditionalExpressionGenerator("&&", ct -> ConditionalExpressionGenerator.joinConditions(condition, thenExpression, true, ct));
        }
        return new ConditionalExpressionGenerator("||", ct -> BoolUtils.getNegatedExpressionText(condition, 14, ct) + " || " + ct.text(thenExpression, 14));
    }

    private static PsiExpression getRedundantComparisonReplacement(@NotNull ConditionalModel model) {
        if (model == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(6);
        }
        @NotNull PsiExpression thenExpression = model.getThenExpression();
        @NotNull PsiExpression elseExpression = model.getElseExpression();
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)model.getCondition()), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        IElementType tokenType = binOp.getOperationTokenType();
        boolean equals = tokenType.equals(JavaTokenType.EQEQ);
        if (!equals && !tokenType.equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
        PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
        if (!ExpressionUtils.isSafelyRecomputableExpression(left) || !ExpressionUtils.isSafelyRecomputableExpression(right)) {
            return null;
        }
        if (TypeConversionUtil.isFloatOrDoubleType((PsiType)left.getType()) && TypeConversionUtil.isFloatOrDoubleType((PsiType)right.getType())) {
            return null;
        }
        EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        if (equivalence.expressionsAreEquivalent(left, thenExpression) && equivalence.expressionsAreEquivalent(right, elseExpression) || equivalence.expressionsAreEquivalent(right, thenExpression) && equivalence.expressionsAreEquivalent(left, elseExpression)) {
            return equals ? elseExpression : thenExpression;
        }
        return null;
    }

    private static ConditionalExpressionGenerator getEqualityGenerator(PsiExpression condition, PsiExpression expression) {
        PsiExpression right;
        PsiExpression left;
        boolean equal = true;
        if (BoolUtils.isNegation(condition)) {
            equal = false;
            left = Objects.requireNonNull(BoolUtils.getNegated(condition));
        } else {
            left = condition;
        }
        if (BoolUtils.isNegation(expression)) {
            equal = !equal;
            right = Objects.requireNonNull(BoolUtils.getNegated(expression));
        } else {
            right = expression;
        }
        String token = equal ? "==" : "!=";
        return new ConditionalExpressionGenerator(token, ct -> ct.text(left, 7) + " " + token + " " + ct.text(right, 7));
    }

    private static PsiExpression expandDiamondsWhenNeeded(PsiExpression thenValue, PsiType requiredType) {
        if (thenValue instanceof PsiNewExpression && !PsiDiamondTypeUtil.canChangeContextForDiamond((PsiNewExpression)((PsiNewExpression)thenValue), (PsiType)requiredType)) {
            return PsiDiamondTypeUtil.expandTopLevelDiamondsInside((PsiExpression)thenValue);
        }
        return thenValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String generateTernary(CommentTracker ct, PsiExpression condition, PsiExpression thenValue, PsiExpression elseValue, PsiType type) {
        thenValue = ConditionalExpressionGenerator.expandDiamondsWhenNeeded(thenValue, type);
        elseValue = ConditionalExpressionGenerator.expandDiamondsWhenNeeded(elseValue, type);
        @NonNls StringBuilder conditional = new StringBuilder();
        String conditionText = ct.text(condition, 15);
        if (condition instanceof PsiConditionalExpression) {
            conditional.append('(').append(conditionText).append(')');
        } else {
            conditional.append(conditionText);
        }
        conditional.append('?');
        PsiType thenType = thenValue.getType();
        PsiType elseType = elseValue.getType();
        if (thenType instanceof PsiPrimitiveType) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)thenType;
            if (!(PsiTypes.nullType().equals(thenType) || elseType instanceof PsiPrimitiveType || type instanceof PsiPrimitiveType)) {
                conditional.append(primitiveType.getBoxedTypeName());
                conditional.append(".valueOf(").append(ct.text((PsiElement)thenValue)).append("):");
                conditional.append(ct.text(elseValue, 15));
                return conditional.toString();
            }
        }
        if (elseType instanceof PsiPrimitiveType) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)elseType;
            if (!(PsiTypes.nullType().equals(elseType) || thenType instanceof PsiPrimitiveType || type instanceof PsiPrimitiveType)) {
                conditional.append(ct.text(thenValue, 15));
                conditional.append(':');
                conditional.append(primitiveType.getBoxedTypeName());
                conditional.append(".valueOf(").append(ct.text((PsiElement)elseValue)).append(')');
                return conditional.toString();
            }
        }
        conditional.append(ct.text(thenValue, 15));
        conditional.append(':');
        conditional.append(ct.text(elseValue, 15));
        return conditional.toString();
    }

    @Nullable
    private static ConditionalExpressionGenerator getSimplifiableBooleanTernaryGenerator(@NotNull ConditionalModel model) {
        if (model == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(7);
        }
        PsiExpression condition = model.getCondition();
        PsiExpression thenExpression = PsiUtil.deparenthesizeExpression((PsiExpression)model.getThenExpression());
        PsiExpression elseExpression = PsiUtil.deparenthesizeExpression((PsiExpression)model.getElseExpression());
        if (thenExpression == null || elseExpression == null) {
            return null;
        }
        PsiElement psiElement = PsiTreeUtil.skipParentsOfType((PsiElement)thenExpression, (Class[])new Class[]{PsiParenthesizedExpression.class});
        if (!(psiElement instanceof PsiConditionalExpression)) {
            return null;
        }
        PsiConditionalExpression thenParent = (PsiConditionalExpression)psiElement;
        PsiElement psiElement2 = PsiTreeUtil.skipParentsOfType((PsiElement)elseExpression, (Class[])new Class[]{PsiParenthesizedExpression.class});
        if (!(psiElement2 instanceof PsiConditionalExpression)) {
            return null;
        }
        PsiConditionalExpression elseParent = (PsiConditionalExpression)psiElement2;
        if (model.getType().equalsToText("java.lang.String") && thenParent == elseParent) {
            PsiLiteral elseLiteral;
            Object object;
            PsiLiteral thenLiteral;
            Object object2;
            if (!(thenExpression instanceof PsiLiteral) || !((object2 = (thenLiteral = (PsiLiteral)thenExpression).getValue()) instanceof String)) {
                return null;
            }
            String thenStr = (String)object2;
            if (!(elseExpression instanceof PsiLiteral) || !((object = (elseLiteral = (PsiLiteral)elseExpression).getValue()) instanceof String)) {
                return null;
            }
            String elseStr = (String)object;
            Boolean thenBool = ConditionalExpressionGenerator.getStringifiedBoolean(thenStr);
            if (thenBool == null) {
                return null;
            }
            Boolean elseBool = ConditionalExpressionGenerator.getStringifiedBoolean(elseStr);
            if (elseBool == null) {
                return null;
            }
            if (!thenBool.equals(elseBool)) {
                boolean negate = thenBool == false;
                return new ConditionalExpressionGenerator("", ct -> {
                    String argText = negate ? BoolUtils.getNegatedExpressionText(condition, ct) : ct.text((PsiElement)condition);
                    PsiType condType = condition.getType();
                    if (condType != null && PsiTypes.booleanType().equals((Object)condType)) {
                        return "java.lang.Boolean.toString(" + argText + ")";
                    }
                    if (!negate) {
                        return ct.text(condition, 1) + ".toString()";
                    }
                    return "java.lang.Boolean.toString(" + argText + ")";
                });
            }
        }
        return null;
    }

    @NotNull
    private static String joinConditions(PsiExpression left, PsiExpression right, boolean isAnd, CommentTracker ct) {
        IElementType tokenType;
        String token;
        int precedence;
        if (isAnd) {
            precedence = 13;
            token = " && ";
            tokenType = JavaTokenType.ANDAND;
        } else {
            precedence = 14;
            token = " || ";
            tokenType = JavaTokenType.OROR;
        }
        PsiPolyadicExpression leftPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)left), PsiPolyadicExpression.class);
        PsiPolyadicExpression rightPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)right), PsiPolyadicExpression.class);
        if (rightPolyadic != null && rightPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ArrayUtil.getFirstElement((Object[])rightPolyadic.getOperands()), left) && !SideEffectChecker.mayHaveSideEffects(left)) {
            String string = ct.text((PsiElement)rightPolyadic);
            if (string == null) {
                ConditionalExpressionGenerator.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (leftPolyadic != null && leftPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ArrayUtil.getLastElement((Object[])leftPolyadic.getOperands()), right) && !SideEffectChecker.mayHaveSideEffects(right)) {
            String string = ct.text((PsiElement)leftPolyadic);
            if (string == null) {
                ConditionalExpressionGenerator.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = ct.text(left, precedence) + token + ct.text(right, precedence);
        if (string == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static Boolean getStringifiedBoolean(@NotNull String b) {
        if (b == null) {
            ConditionalExpressionGenerator.$$$reportNull$$$0(11);
        }
        return switch (b) {
            case "true" -> Boolean.TRUE;
            case "false" -> Boolean.FALSE;
            default -> null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/ConditionalExpressionGenerator";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/ConditionalExpressionGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "joinConditions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRedundantComparisonReplacement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSimplifiableBooleanTernaryGenerator";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStringifiedBoolean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

