/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public final class ImplicitCallToSuperInspection
extends BaseInspection {
    public boolean m_ignoreForObjectSubclasses = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("implicit.call.to.super.problem.descriptor", new Object[0]);
        if (string == null) {
            ImplicitCallToSuperInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new AddExplicitSuperCall();
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreForObjectSubclasses", (String)InspectionGadgetsBundle.message("implicit.call.to.super.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ImplicitCallToSuperInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitCallToSuperVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/ImplicitCallToSuperInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AddExplicitSuperCall
    extends PsiUpdateModCommandQuickFix {
        private AddExplicitSuperCall() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("implicit.call.to.super.make.explicit.quickfix", new Object[0]);
            if (string == null) {
                AddExplicitSuperCall.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement methodName, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                AddExplicitSuperCall.$$$reportNull$$$0(1);
            }
            if (methodName == null) {
                AddExplicitSuperCall.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AddExplicitSuperCall.$$$reportNull$$$0(3);
            }
            if (!((parent = methodName.getParent()) instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)parent;
            PsiCodeBlock body = method.getBody();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiStatement newStatement = factory.createStatementFromText("super();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            if (body == null) {
                return;
            }
            PsiJavaToken brace = body.getLBrace();
            body.addAfter((PsiElement)newStatement, (PsiElement)brace);
            styleManager.reformat((PsiElement)body);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/ImplicitCallToSuperInspection$AddExplicitSuperCall";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/ImplicitCallToSuperInspection$AddExplicitSuperCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ImplicitCallToSuperVisitor
    extends BaseInspectionVisitor {
        private ImplicitCallToSuperVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String superClassName;
            PsiClass superClass;
            if (method == null) {
                ImplicitCallToSuperVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!method.isConstructor() || method.getNameIdentifier() == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isEnum() || containingClass.isRecord()) {
                return;
            }
            if (ImplicitCallToSuperInspection.this.m_ignoreForObjectSubclasses && (superClass = containingClass.getSuperClass()) != null && "java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
                return;
            }
            PsiStatement firstStatement = ControlFlowUtils.getFirstStatementInBlock(method.getBody());
            if (firstStatement == null) {
                this.registerMethodError(method, new Object[0]);
                return;
            }
            if (ImplicitCallToSuperVisitor.isConstructorCall(firstStatement) || PsiUtilCore.hasErrorElementChild((PsiElement)firstStatement)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean isConstructorCall(PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            return JavaPsiConstructorUtil.isConstructorCall((PsiElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/style/ImplicitCallToSuperInspection$ImplicitCallToSuperVisitor", "visitMethod"));
        }
    }
}

