/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class OptionalContainsCollectionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message(type instanceof PsiArrayType ? "optional.contains.array.problem.descriptor" : "optional.contains.collection.problem.descriptor", new Object[0]);
        if (string == null) {
            OptionalContainsCollectionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            OptionalContainsCollectionInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new OptionalContainsCollectionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/OptionalContainsCollectionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class OptionalContainsCollectionVisitor
    extends BaseInspectionVisitor {
        private OptionalContainsCollectionVisitor() {
        }

        public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
            if (typeElement == null) {
                OptionalContainsCollectionVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeElement(typeElement);
            PsiType type = typeElement.getType();
            if (!TypeUtils.isOptional(type)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            if (referenceElement == null) {
                return;
            }
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList == null) {
                return;
            }
            PsiTypeElement[] typeParameterElements = parameterList.getTypeParameterElements();
            if (typeParameterElements.length != 1) {
                return;
            }
            PsiTypeElement typeParameterElement = typeParameterElements[0];
            PsiType parameterType = typeParameterElement.getType();
            if (!(parameterType instanceof PsiArrayType) && !CollectionUtils.isCollectionClassOrInterface(parameterType)) {
                return;
            }
            this.registerError((PsiElement)typeParameterElement, parameterType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/siyeh/ig/style/OptionalContainsCollectionInspection$OptionalContainsCollectionVisitor", "visitTypeElement"));
        }
    }
}

