/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadLocalSetWithNullInspection
extends BaseInspection {
    private final CallMatcher THREAD_LOCAL_SET = CallMatcher.instanceCall("java.lang.ThreadLocal", "set").parameterCount(1);

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.local.set.with.null.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadLocalSetWithNullInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ReplaceWithRemove();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(expression);
                if (!ThreadLocalSetWithNullInspection.this.THREAD_LOCAL_SET.test(expression)) {
                    return;
                }
                PsiExpression[] arguments = expression.getArgumentList().getExpressions();
                if (arguments.length != 1) {
                    return;
                }
                PsiExpression firstArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
                if (firstArgument == null) {
                    return;
                }
                if (!(firstArgument instanceof PsiLiteralExpression)) {
                    return;
                }
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)firstArgument;
                if (!ExpressionUtils.isNullLiteral((PsiExpression)literalExpression)) {
                    return;
                }
                PsiExpression qualifierExpression = expression.getMethodExpression().getQualifierExpression();
                if (qualifierExpression == null) {
                    return;
                }
                this.registerMethodCallError(expression, new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/ThreadLocalSetWithNullInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadLocalSetWithNullInspection", "buildErrorString"));
    }

    private static class ReplaceWithRemove
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithRemove() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("thread.local.set.with.null.quickfix", new Object[0]);
            if (string == null) {
                ReplaceWithRemove.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            PsiMethodCallExpression methodCallExpression;
            PsiExpression qualifierExpression;
            if (project == null) {
                ReplaceWithRemove.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithRemove.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithRemove.$$$reportNull$$$0(3);
            }
            if ((qualifierExpression = (methodCallExpression = (PsiMethodCallExpression)(parent = element.getParent()).getParent()).getMethodExpression().getQualifierExpression()) == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            tracker.markUnchanged(qualifierExpression);
            String newExpressionText = qualifierExpression.getText() + ".remove()";
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpressionText, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/threading/ThreadLocalSetWithNullInspection$ReplaceWithRemove";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/threading/ThreadLocalSetWithNullInspection$ReplaceWithRemove";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

