/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.UserRenderersConfigurable;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Type;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CreateRendererActionUtils {
    public static void showCreateRendererDialog(final JavaValue javaValue) {
        EvaluationContextImpl evaluationContext = javaValue.getEvaluationContext();
        final Project project = evaluationContext.getProject();
        evaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(evaluationContext.getSuspendContext()){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                Type type;
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = (type = javaValue.getDescriptor().getType()) != null ? type.name() : null;
                DebuggerUIUtil.invokeLater(() -> {
                    final UserRenderersConfigurable ui = new UserRenderersConfigurable();
                    ConfigurableBase<UserRenderersConfigurable, NodeRendererSettings> configurable = new ConfigurableBase<UserRenderersConfigurable, NodeRendererSettings>(this, "reference.idesettings.debugger.typerenderers", JavaDebuggerBundle.message((String)"user.renderers.configurable.display.name", (Object[])new Object[0]), "reference.idesettings.debugger.typerenderers"){

                        @NotNull
                        protected NodeRendererSettings getSettings() {
                            NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
                            if (nodeRendererSettings == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return nodeRendererSettings;
                        }

                        protected UserRenderersConfigurable createUi() {
                            return ui;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/CreateRendererActionUtils$1$1", "getSettings"));
                        }
                    };
                    SingleConfigurableEditor editor = new SingleConfigurableEditor(project, (Configurable)configurable);
                    if (name != null) {
                        CompoundReferenceRenderer renderer = NodeRendererSettings.getInstance().createCompoundReferenceRenderer(StringUtil.getShortName((String)name), name, null, null);
                        renderer.setEnabled(true);
                        renderer.setHasOverhead(true);
                        ui.addRenderer(renderer);
                    }
                    editor.show();
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/CreateRendererActionUtils$1", "contextAction"));
            }
        });
    }
}

