/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.CommonBundle;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XDropFrameHandler;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.VMDisconnectedException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmDropFrameActionHandler
implements XDropFrameHandler {
    private static final Logger LOG = Logger.getInstance(JvmDropFrameActionHandler.class);
    @NotNull
    private final DebuggerSession myDebugSession;

    public JvmDropFrameActionHandler(@NotNull DebuggerSession process) {
        if (process == null) {
            JvmDropFrameActionHandler.$$$reportNull$$$0(0);
        }
        this.myDebugSession = process;
    }

    public ThreeState canDropFrame(@NotNull XStackFrame frame) {
        JavaStackFrame javaStackFrame;
        if (frame == null) {
            JvmDropFrameActionHandler.$$$reportNull$$$0(1);
        }
        if (frame instanceof JavaStackFrame && (javaStackFrame = (JavaStackFrame)frame).getStackFrameProxy().getVirtualMachine().canPopFrames()) {
            return javaStackFrame.getDescriptor().canDrop();
        }
        return ThreeState.NO;
    }

    public CompletableFuture<Boolean> canDropFrameAsync(@NotNull XStackFrame frame) {
        JavaStackFrame javaStackFrame;
        if (frame == null) {
            JvmDropFrameActionHandler.$$$reportNull$$$0(2);
        }
        if (frame instanceof JavaStackFrame && (javaStackFrame = (JavaStackFrame)frame).getStackFrameProxy().getVirtualMachine().canPopFrames()) {
            return javaStackFrame.getDescriptor().canDropAsync();
        }
        return CompletableFuture.completedFuture(false);
    }

    public void drop(@NotNull XStackFrame frame) {
        if (frame == null) {
            JvmDropFrameActionHandler.$$$reportNull$$$0(3);
        }
        if (frame instanceof JavaStackFrame) {
            final JavaStackFrame stackFrame = (JavaStackFrame)frame;
            final Project project = this.myDebugSession.getProject();
            final DebugProcessImpl debugProcess = this.myDebugSession.getProcess();
            final DebuggerContextImpl debuggerContext = this.myDebugSession.getContextManager().getContext();
            try {
                this.myDebugSession.setSteppingThrough(stackFrame.getStackFrameProxy().threadProxy());
                if (JvmDropFrameActionHandler.evaluateFinallyBlocks(project, XDebuggerBundle.message((String)"xdebugger.reset.frame.title", (Object[])new Object[0]), stackFrame, new XDebuggerEvaluator.XEvaluationCallback(){

                    public void evaluated(@NotNull XValue result) {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        JvmDropFrameActionHandler.popFrame(debugProcess, debuggerContext, stackFrame);
                    }

                    public void errorOccurred(@NotNull String errorMessage) {
                        if (errorMessage == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        JvmDropFrameActionHandler.showError(project, JavaDebuggerBundle.message((String)"error.executing.finally", (Object[])new Object[]{errorMessage}), XDebuggerBundle.message((String)"xdebugger.reset.frame.title", (Object[])new Object[0]));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "result";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorMessage";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/debugger/actions/JvmDropFrameActionHandler$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "evaluated";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "errorOccurred";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                })) {
                    return;
                }
                JvmDropFrameActionHandler.popFrame(debugProcess, debuggerContext, stackFrame);
            }
            catch (InvalidStackFrameException | VMDisconnectedException runtimeException) {
                // empty catch block
            }
        }
    }

    public static boolean evaluateFinallyBlocks(Project project, @Nls String title, JavaStackFrame stackFrame, XDebuggerEvaluator.XEvaluationCallback callback) {
        List<PsiStatement> statements;
        if (!"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !(statements = JvmDropFrameActionHandler.getFinallyStatements(project, stackFrame.getDescriptor().getSourcePosition())).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (PsiStatement statement : statements) {
                sb.append("\n").append(statement.getText());
            }
            if ("EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME)) {
                JvmDropFrameActionHandler.evaluateAndAct(project, stackFrame, sb, callback);
                return true;
            }
            int res = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)(JavaDebuggerBundle.message((String)"warning.finally.block.detected", (Object[])new Object[0]) + String.valueOf(sb))).icon(Messages.getWarningIcon())).yesText(JavaDebuggerBundle.message((String)"button.execute.finally", (Object[])new Object[0]))).noText(JavaDebuggerBundle.message((String)"button.drop.anyway", (Object[])new Object[0]))).cancelText(CommonBundle.getCancelButtonText()).doNotAsk(new DoNotAskOption(){

                public boolean isToBeShown() {
                    return !"EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME);
                }

                public void setToBeShown(boolean value, int exitCode) {
                    DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME = !value ? (exitCode == 0 ? "EvaluateFinallyAlways" : "EvaluateFinallyNever") : "EvaluateFinallyAsk";
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    String string = UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/JvmDropFrameActionHandler$2", "getDoNotShowMessage"));
                }
            })).show(project);
            switch (res) {
                case 2: {
                    return true;
                }
                case 1: {
                    break;
                }
                case 0: {
                    JvmDropFrameActionHandler.evaluateAndAct(project, stackFrame, sb, callback);
                    return true;
                }
            }
        }
        return false;
    }

    private static void popFrame(DebugProcessImpl debugProcess, DebuggerContextImpl debuggerContext, JavaStackFrame stackFrame) {
        Objects.requireNonNull(debuggerContext.getManagerThread()).schedule(debugProcess.createPopFrameCommand(debuggerContext, stackFrame.getStackFrameProxy()));
    }

    private static void evaluateAndAct(Project project, JavaStackFrame stackFrame, StringBuilder sb, XDebuggerEvaluator.XEvaluationCallback callback) {
        XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator != null) {
            evaluator.evaluate((XExpression)XExpressionImpl.fromText((String)sb.toString(), (EvaluationMode)EvaluationMode.CODE_FRAGMENT), callback, stackFrame.getSourcePosition());
        } else {
            Messages.showMessageDialog((Project)project, (String)XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]), (String)XDebuggerBundle.message((String)"xdebugger.reset.frame.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    public static void showError(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)message, (String)title, (Icon)Messages.getErrorIcon()), ModalityState.any());
    }

    private static List<PsiStatement> getFinallyStatements(Project project, @Nullable SourcePosition position) {
        if (position == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiStatement> res = new ArrayList<PsiStatement>();
        PsiElement element = position.getFile().findElementAt(position.getOffset());
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
        while (tryStatement != null) {
            PsiCodeBlock finallyBlock;
            PsiResourceList resourceList = tryStatement.getResourceList();
            if (resourceList != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                for (PsiResourceListElement listElement : resourceList) {
                    String varName = JvmDropFrameActionHandler.getResourceName(listElement);
                    if (varName == null) continue;
                    res.add(factory.createStatementFromText("if (" + varName + " != null) " + varName + ".close();", (PsiElement)tryStatement));
                }
            }
            if ((finallyBlock = tryStatement.getFinallyBlock()) != null) {
                ContainerUtil.addAll(res, (Object[])finallyBlock.getStatements());
            }
            tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiTryStatement.class);
        }
        return res;
    }

    private static String getResourceName(PsiResourceListElement resource) {
        PsiResourceListElement psiResourceListElement = resource;
        Objects.requireNonNull(psiResourceListElement);
        PsiResourceListElement psiResourceListElement2 = psiResourceListElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiResourceVariable.class, PsiResourceExpression.class}, (Object)psiResourceListElement2, n)) {
            case 0 -> {
                PsiResourceVariable variable = (PsiResourceVariable)psiResourceListElement2;
                yield variable.getName();
            }
            case 1 -> {
                PsiResourceExpression expression = (PsiResourceExpression)psiResourceListElement2;
                yield expression.getExpression().getText();
            }
            default -> {
                LOG.error("Unknown PsiResourceListElement type: " + String.valueOf(resource.getClass()));
                yield null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/actions/JvmDropFrameActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canDropFrame";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canDropFrameAsync";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "drop";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

